/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.animation;

import net.tardis.mod.client.animation.ExteriorAnimation;
import net.tardis.mod.client.animation.ExteriorAnimationEntry;
import net.tardis.mod.enums.EnumMatterState;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class ClassicExteriorAnimation
extends ExteriorAnimation {
    private float alpha = 0.0f;

    public ClassicExteriorAnimation(ExteriorAnimationEntry entry, ExteriorTile tile) {
        super(entry, tile);
    }

    @Override
    public void tick(int timeLeft) {
        if (this.exterior.getMatterState() == EnumMatterState.DEMAT) {
            this.alpha = (float)timeLeft / (float)this.getMaxTime();
        } else if (this.exterior.getMatterState() == EnumMatterState.REMAT) {
            this.alpha = 1.0f - (float)timeLeft / (float)this.getMaxTime();
        }
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void startAnim(EnumMatterState state, int dematTime) {
        super.startAnim(state, dematTime);
        this.alpha = state == EnumMatterState.DEMAT ? 1.0f : 0.0f;
    }
}

