/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client;

import com.google.common.collect.Lists;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tardis.mod.boti.BotiChunk;
import net.tardis.mod.boti.IBotiEnabled;
import net.tardis.mod.boti.WorldShell;
import net.tardis.mod.boti.stores.EntityStorage;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.client.guis.IGetStructures;
import net.tardis.mod.client.guis.INeedSyncing;
import net.tardis.mod.client.guis.INeedTardisNames;
import net.tardis.mod.client.guis.INeedWorlds;
import net.tardis.mod.client.guis.monitors.WaypointMonitorScreen;
import net.tardis.mod.enums.EnumMatterState;
import net.tardis.mod.misc.BrokenExteriorType;
import net.tardis.mod.missions.MiniMission;
import net.tardis.mod.missions.MiniMissionType;
import net.tardis.mod.network.packets.BOTITileMessage;
import net.tardis.mod.network.packets.BrokenTardisParticleSpawn;
import net.tardis.mod.network.packets.EngineSliderSyncMessage;
import net.tardis.mod.network.packets.LaserDamageSyncMessage;
import net.tardis.mod.network.packets.MissionUpdateMessage;
import net.tardis.mod.network.packets.SyncDimensionListMessage;
import net.tardis.mod.network.packets.TardisNameGuiMessage;
import net.tardis.mod.network.packets.TelepathicGetStructuresMessage;
import net.tardis.mod.network.packets.VMGetWorldsMessage;
import net.tardis.mod.network.packets.WaypointOpenMessage;
import net.tardis.mod.network.packets.exterior.ExteriorData;
import net.tardis.mod.registries.MissionRegistry;
import net.tardis.mod.tileentities.BrokenExteriorTile;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class ClientPacketHandler {
    public static void handleClientSideNames(TardisNameGuiMessage mes) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s instanceof INeedTardisNames) {
            ((INeedTardisNames)s).setNamesFromServer(mes.getNames());
        }
    }

    public static void handleTelepathicStructureNames(TelepathicGetStructuresMessage mes) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s instanceof IGetStructures) {
            IGetStructures screen = (IGetStructures)s;
            screen.setTelepathicStructureNamesFromServer(mes.getSearchNames());
        }
    }

    public static void handleVMWorlds(VMGetWorldsMessage mes) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s instanceof INeedWorlds) {
            INeedWorlds screen = (INeedWorlds)s;
            screen.setWorldsFromServer(mes.getWorlds());
        }
    }

    public static PlayerEntity getPlayer(NetworkEvent.Context context) {
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            return context.getSender();
        }
        return (PlayerEntity)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71439_g);
    }

    public static void handleWorldShellEntity(int type, EntityStorage store, BlockPos pos) {
        if (type == 0) {
            IBotiEnabled boti;
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
            if (te instanceof IBotiEnabled && (boti = (IBotiEnabled)te).getBotiWorld() != null) {
                boti.getBotiWorld().updateEntities(Lists.newArrayList((Object[])new EntityStorage[]{store}));
            }
        } else {
            Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(tile -> {
                if (tile.getBotiWorld() != null) {
                    tile.getBotiWorld().updateEntities(Lists.newArrayList((Object[])new EntityStorage[]{store}));
                }
            });
        }
    }

    public static void handleBOTIMessage(BlockPos pos, WorldShell shell) {
        if (pos != null) {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
            if (te instanceof IBotiEnabled) {
                ClientPacketHandler.combineOrSetBOTI((IBotiEnabled)te, shell);
            }
        } else {
            Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> ClientPacketHandler.combineOrSetBOTI(data, shell));
        }
    }

    public static void combineOrSetBOTI(IBotiEnabled boti, WorldShell shell) {
        if (boti.getBotiWorld() == null || !boti.getBotiWorld().getOffset().equals((Object)shell.getOffset())) {
            boti.setBotiWorld(shell);
            shell.setNeedsUpdate(true);
            return;
        }
        if (boti.getBotiWorld().getOffset().equals((Object)shell.getOffset())) {
            boti.getBotiWorld().combine(shell);
        }
    }

    public static void syncDimensionList(SyncDimensionListMessage packet) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        RegistryKey<World> key = packet.getId();
        if (player == null || key == null) {
            return;
        }
        Set worlds = player.field_71174_a.func_239164_m_();
        if (worlds == null) {
            return;
        }
        if (packet.getAdd()) {
            worlds.add(key);
        } else {
            worlds.remove(key);
        }
    }

    public static void handleTardisParticleSpawn(BrokenTardisParticleSpawn mes) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(mes.getPos());
        if (te instanceof BrokenExteriorTile) {
            BrokenExteriorType type = ((BrokenExteriorTile)te).getBrokenType();
            type.spawnHappyPart(te.func_145831_w(), mes.getPos());
        }
    }

    public static void handleWaypointOpenClient(WaypointOpenMessage mes) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof WaypointMonitorScreen) {
            ((WaypointMonitorScreen)screen).setWaypoints(mes.getWaypointMap());
        }
    }

    public static void handleMissionUpdateClient(MissionUpdateMessage mes) {
        Minecraft.func_71410_x().field_71441_e.getCapability(Capabilities.MISSION).ifPresent(misCap -> {
            MiniMission mis = misCap.getMissionForPos(mes.getPos());
            if (mis != null) {
                mis.deserializeNBT(mes.getNBT());
            } else {
                mis = ((MiniMissionType)MissionRegistry.MISSION_REGISTRY.get().getValue(mes.getKey())).create((World)Minecraft.func_71410_x().field_71441_e, mes.getPos(), mes.getRange());
                mis.deserializeNBT(mes.getNBT());
                misCap.addMission(mis);
            }
        });
    }

    public static void handleBotiTileMessage(BOTITileMessage mes) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (mes.pos != null) {
            WorldShell shell;
            TileEntity boti = world.func_175625_s(mes.pos);
            if (boti instanceof IBotiEnabled && (shell = ((IBotiEnabled)boti).getBotiWorld()) != null) {
                shell.addTile(mes.store.pos, mes.store.createTile((World)shell.getWorld()));
            }
        } else {
            world.getCapability(Capabilities.TARDIS_DATA).ifPresent(cap -> {
                if (cap.getBotiWorld() != null) {
                    cap.getBotiWorld().addTile(mes.store.pos, mes.store.createTile((World)cap.getBotiWorld().getWorld()));
                }
            });
        }
    }

    public static void handleMaterializationPacket(BlockPos pos, EnumMatterState state, int materializeTime, int maxMaterializeTime) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
        if (te instanceof ExteriorTile) {
            ExteriorTile exterior = (ExteriorTile)te;
            if (state == EnumMatterState.DEMAT) {
                exterior.demat(materializeTime);
            } else if (state == EnumMatterState.REMAT) {
                exterior.remat(materializeTime);
            }
            exterior.setMaterializeTime(materializeTime, maxMaterializeTime);
        }
    }

    public static void handleExteriorData(BlockPos pos, ExteriorData data) {
        TileEntity te;
        if (Minecraft.func_71410_x().field_71441_e != null && (te = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos)) instanceof ExteriorTile) {
            data.apply((ExteriorTile)te);
        }
    }

    public static void handleBotiChunkMessage(BotiChunk chunk, BlockPos pos) {
        TileEntity te;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && !BlockPos.field_177992_a.equals((Object)pos) && (te = world.func_175625_s(pos)) instanceof IBotiEnabled) {
            ((IBotiEnabled)te).getBotiWorld().addChunk(chunk);
        }
    }

    public static void handleEngineSliderSyncClient(EngineSliderSyncMessage mes) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof INeedSyncing) {
                INeedSyncing syncingScreen = (INeedSyncing)screen;
                syncingScreen.setStatesFromServer(mes.upgradeStates);
            }
        });
    }

    public static void handleLaserDamageRender(LaserDamageSyncMessage mes) {
        LivingEntity living;
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(mes.id);
        if (entity != null && entity instanceof LivingEntity && (living = (LivingEntity)entity).func_70089_S()) {
            ClientHelper.ENTITIES_HURT_BY_LASER.add((Entity)living);
        }
    }
}

