/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.tardis.api.events.DimensionLightMapModificationEvent;
import net.tardis.mod.Tardis;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.client.guis.ARSTabletKillScreen;
import net.tardis.mod.client.guis.ARSTabletScreen;
import net.tardis.mod.client.guis.ArsScreen;
import net.tardis.mod.client.guis.CommunicatorScreen;
import net.tardis.mod.client.guis.DiagnosticGui;
import net.tardis.mod.client.guis.DialogGui;
import net.tardis.mod.client.guis.MonitorRemoteGui;
import net.tardis.mod.client.guis.TardisSendDistressScreen;
import net.tardis.mod.client.guis.TelepathicScreen;
import net.tardis.mod.client.guis.TransductionBarrierEdit;
import net.tardis.mod.client.guis.manual.ManualScreen;
import net.tardis.mod.client.guis.monitors.CoralMonitorScreen;
import net.tardis.mod.client.guis.monitors.EyeMonitorScreen;
import net.tardis.mod.client.guis.monitors.GalvanicMonitorScreen;
import net.tardis.mod.client.guis.monitors.RCAMonitorScreen;
import net.tardis.mod.client.guis.monitors.SpinMonitorScreen;
import net.tardis.mod.client.guis.monitors.SteamMonitorScreen;
import net.tardis.mod.client.guis.monitors.ToyotaMonitorScreen;
import net.tardis.mod.client.guis.monitors.XionMonitorScreen;
import net.tardis.mod.client.guis.radial.SonicModeScreen;
import net.tardis.mod.client.guis.vm.VortexMDistressScreen;
import net.tardis.mod.client.guis.vm.VortexMGui;
import net.tardis.mod.client.guis.vm.VortexMTeleportGui;
import net.tardis.mod.client.models.entity.SpacesuitModel;
import net.tardis.mod.contexts.gui.EntityContext;
import net.tardis.mod.contexts.gui.GuiContextDiagnostic;
import net.tardis.mod.entity.humanoid.AbstractHumanoidEntity;
import net.tardis.mod.experimental.sound.EntityMovingSound;
import net.tardis.mod.items.TItems;
import net.tardis.mod.misc.GuiContext;
import net.tardis.mod.sounds.TSounds;
import org.apache.logging.log4j.Level;

public class ClientHelper {
    public static final HashMap<ConsoleRoom, ResourceLocation> INTERIOR_PREVIEW_TEXTURES = new HashMap();
    private static final SpacesuitModel SUIT_HEAD = new SpacesuitModel(1.0f, EquipmentSlotType.HEAD);
    private static final SpacesuitModel SUIT_BODY = new SpacesuitModel(1.0f, EquipmentSlotType.CHEST);
    private static final SpacesuitModel SUIT_LEGS = new SpacesuitModel(1.0f, EquipmentSlotType.LEGS);
    private static final SpacesuitModel SUIT_FEET = new SpacesuitModel(1.0f, EquipmentSlotType.FEET);
    public static List<Entity> ENTITIES_HURT_BY_LASER = new ArrayList<Entity>();

    public static Map<Item, BipedModel<?>> getSpacesuitArmorModel(ItemStack itemStack) {
        HashMap map = new HashMap();
        map.put((Item)TItems.SPACE_HELM.get(), SUIT_HEAD);
        map.put((Item)TItems.SPACE_CHEST.get(), SUIT_BODY);
        map.put((Item)TItems.SPACE_LEGS.get(), SUIT_LEGS);
        map.put((Item)TItems.SPACE_BOOTS.get(), SUIT_FEET);
        return map;
    }

    public static ResourceLocation urlToTexture(URL url) {
        URLConnection uc = null;
        NativeImage image = null;
        try {
            uc = url.openConnection();
            uc.connect();
            uc = url.openConnection();
            uc.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36");
            Tardis.LOGGER.warn("Downloading Image from: {}", (Object)url.toString());
            image = NativeImage.func_195713_a((InputStream)uc.getInputStream());
            return Minecraft.func_71410_x().func_110434_K().func_110578_a("interior_", new DynamicTexture(image));
        }
        catch (IOException e) {
            e.printStackTrace();
            return DefaultPlayerSkin.func_177335_a();
        }
    }

    public static void updateLightmap(float partialTicks, ClientWorld clientworld, float f, float f1, float f3, float f2, Vector3f vector3f, float f4, Vector3f lightMapColours, int i, int j, float blockBrightness, float f6, float f7, float f8) {
        blockBrightness = ClientHelper.onDimensionLightMapUpdate((World)clientworld, partialTicks, blockBrightness, lightMapColours).getBlockBrightness();
    }

    public static DimensionLightMapModificationEvent onDimensionLightMapUpdate(World world, float partialTicks, float blockBrightness, Vector3f lightMapColors) {
        DimensionLightMapModificationEvent event = new DimensionLightMapModificationEvent(world, partialTicks, blockBrightness, lightMapColors);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static ITextComponent getUsernameFromUUID(UUID id) {
        NetworkPlayerInfo info;
        StringTextComponent idComp = new StringTextComponent(id.toString());
        if (Minecraft.func_71410_x().func_147114_u() != null && (info = Minecraft.func_71410_x().func_147114_u().func_175102_a(id)) != null && info.func_178845_a() != null) {
            String name = info.func_178845_a().getName();
            return name == null ? idComp : new StringTextComponent(name);
        }
        return idComp;
    }

    public static void openGui(Screen screen) {
        Minecraft.func_71410_x().func_147108_a(screen);
    }

    public static void openGUI(int guiId, GuiContext context) {
        switch (guiId) {
            case 1: {
                Minecraft.func_71410_x().func_147108_a((Screen)new SteamMonitorScreen());
                break;
            }
            case 5: {
                Minecraft.func_71410_x().func_147108_a((Screen)new VortexMGui());
                break;
            }
            case 6: {
                Minecraft.func_71410_x().func_147108_a((Screen)new VortexMTeleportGui());
                break;
            }
            case 7: {
                Minecraft.func_71410_x().func_147108_a((Screen)new VortexMDistressScreen());
                break;
            }
            case 8: {
                Minecraft.func_71410_x().func_147108_a((Screen)new EyeMonitorScreen());
                break;
            }
            case 10: {
                Minecraft.func_71410_x().func_147108_a((Screen)new ManualScreen(context));
                break;
            }
            case 11: {
                Minecraft.func_71410_x().func_147108_a((Screen)new ArsScreen());
                break;
            }
            case 12: {
                Minecraft.func_71410_x().func_147108_a((Screen)new TelepathicScreen());
                break;
            }
            case 9: {
                Minecraft.func_71410_x().func_147108_a((Screen)new GalvanicMonitorScreen());
                break;
            }
            case 13: {
                Minecraft.func_71410_x().func_147108_a((Screen)new RCAMonitorScreen());
                break;
            }
            case 14: {
                Minecraft.func_71410_x().func_147108_a((Screen)new ARSTabletScreen(context));
                break;
            }
            case 15: {
                Minecraft.func_71410_x().func_147108_a((Screen)new CommunicatorScreen());
                break;
            }
            case 16: {
                Minecraft.func_71410_x().func_147108_a((Screen)new TransductionBarrierEdit(context));
                break;
            }
            case 17: {
                Minecraft.func_71410_x().func_147108_a((Screen)new ARSTabletKillScreen(context));
                break;
            }
            case 18: {
                Minecraft.func_71410_x().func_147108_a((Screen)new XionMonitorScreen());
                break;
            }
            case 19: {
                Minecraft.func_71410_x().func_147108_a((Screen)new ToyotaMonitorScreen());
                break;
            }
            case 20: {
                Minecraft.func_71410_x().func_147108_a((Screen)new CoralMonitorScreen());
                break;
            }
            case 21: {
                Minecraft.func_71410_x().func_147108_a((Screen)new SpinMonitorScreen());
                break;
            }
            case 22: {
                Minecraft.func_71410_x().func_147108_a((Screen)new DiagnosticGui((GuiContextDiagnostic)context));
                break;
            }
            case 23: {
                Minecraft.func_71410_x().func_147108_a((Screen)new MonitorRemoteGui(context));
                break;
            }
            case 25: {
                ClientHelper.openGui(new TardisSendDistressScreen());
                break;
            }
            case 26: {
                ClientHelper.openGui(new DialogGui((AbstractHumanoidEntity)((EntityContext)context).entity));
                break;
            }
            case 27: {
                Minecraft.func_71410_x().func_147108_a((Screen)new SonicModeScreen((ITextComponent)new StringTextComponent("")));
                break;
            }
            case 3: {
                Minecraft.func_71410_x().func_147108_a(null);
                break;
            }
        }
    }

    public static void playMovingSound(Entity entity, SoundEvent soundEvent, SoundCategory soundCategory, float vol, boolean repeat) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new EntityMovingSound(entity, soundEvent, soundCategory, vol, repeat));
    }

    public static void shutTheFuckUp(SoundEvent event, SoundCategory type) {
        Minecraft.func_71410_x().func_147118_V().func_195478_a(event == null ? null : event.getRegistryName(), type);
    }

    public static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static ClientWorld getClientWorldCasted() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static DimensionType getDimensionType(ClientWorld world, RegistryKey<DimensionType> dimTypeKey) {
        return (DimensionType)world.func_241828_r().func_243612_b(Registry.field_239698_ad_).func_243576_d(dimTypeKey);
    }

    public static void playSteamSoundOnClient(World world, BlockPos pos) {
        world.func_184133_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, pos, (SoundEvent)TSounds.STEAM_HISS.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public static JsonObject getResourceAsJson(ResourceLocation loc) {
        try {
            IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(loc);
            if (resource != null) {
                return new JsonParser().parse((Reader)new InputStreamReader(resource.func_199027_b())).getAsJsonObject();
            }
        }
        catch (IOException e) {
            Tardis.LOGGER.log(Level.ALL, "Error occured parsing json file " + loc.toString());
            Tardis.LOGGER.catching(Level.ALL, (Throwable)e);
        }
        return null;
    }

    public static <T> Optional<T> getItemFromDynamicRegistry(RegistryKey<Registry<T>> registry, ResourceLocation key) {
        return Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(registry).func_241873_b(key);
    }

    public static float getPocketWatchRotFromTime(ClientWorld world) {
        float rot = world.func_72929_e((float)world.func_72820_D()) * 2.0f % 360.0f * 360.0f;
        if (rot > 315.0f) {
            return 7.0f;
        }
        if (rot > 270.0f) {
            return 6.0f;
        }
        if (rot > 225.0f) {
            return 5.0f;
        }
        if (rot > 180.0f) {
            return 4.0f;
        }
        if (rot > 135.0f) {
            return 3.0f;
        }
        if (rot > 90.0f) {
            return 2.0f;
        }
        if (rot > 45.0f) {
            return 1.0f;
        }
        return 0.0f;
    }
}

