/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.text.DecimalFormat;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tardis.api.events.DimensionLightMapModificationEvent;
import net.tardis.mod.blocks.exteriors.ExteriorBlock;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.ITardisWorldData;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.client.TClientRegistry;
import net.tardis.mod.client.TRenderTypes;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;
import net.tardis.mod.client.renderers.boti.PortalInfo;
import net.tardis.mod.helper.TRenderHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.DebugItem;
import net.tardis.mod.items.TItems;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.BessieHornMessage;
import net.tardis.mod.network.packets.SnapMessage;
import net.tardis.mod.network.packets.UpdateLaserGun;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.EmotionHandler;
import net.tardis.mod.world.dimensions.TDimensions;

@Mod.EventBusSubscriber(modid="tardis", value={Dist.CLIENT})
public class ClientEvents {
    public static DecimalFormat FORMAT = new DecimalFormat("###");
    public static boolean BOBBING = false;

    @SubscribeEvent
    public static void onBlockHighlight(DrawHighlightEvent event) {
        BlockRayTraceResult result;
        BlockState state;
        ActiveRenderInfo information = event.getInfo();
        MatrixStack matrixStack = event.getMatrix();
        if (event.getTarget() instanceof BlockRayTraceResult && (state = Minecraft.func_71410_x().field_71441_e.func_180495_p((result = (BlockRayTraceResult)event.getTarget()).func_216350_a())).func_177230_c() instanceof ExteriorBlock) {
            event.setCanceled(true);
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        TRenderHelper.drawSquarenessGunOutline((PlayerEntity)player, matrixStack, information, event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        MatrixStack matrixStack = event.getMatrixStack();
        Vector3d proj = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227860_a_();
        BOTIRenderer.RENDERING_BOTI = true;
        for (PortalInfo info : BOTIRenderer.PORTALS) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(-proj.field_72450_a, -proj.field_72448_b, -proj.field_72449_c);
            matrixStack.func_227861_a_(info.getPosition().func_82615_a(), info.getPosition().func_82617_b(), info.getPosition().func_82616_c());
            info.translate(matrixStack);
            BOTIRenderer.renderBOTI(matrixStack, info, event.getPartialTicks());
            matrixStack.func_227865_b_();
        }
        BOTIRenderer.PORTALS.clear();
        BOTIRenderer.RENDERING_BOTI = false;
        matrixStack.func_227865_b_();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Vector3d projectedView1 = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c();
        double correctedRenderPosX1 = projectedView1.func_82615_a();
        double correctedRenderPosY1 = projectedView1.func_82617_b();
        double correctedRenderPosZ1 = projectedView1.func_82616_c();
        IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(TRenderTypes.LINES);
        TRenderHelper.drawDebugBoundingBoxes((PlayerEntity)player, matrixStack, builder, correctedRenderPosX1, correctedRenderPosY1, correctedRenderPosZ1);
    }

    @SubscribeEvent
    public static void input(InputUpdateEvent event) {
        if (event.getMovementInput().field_78901_c) {
            Network.sendToServer(new BessieHornMessage());
        }
    }

    @SubscribeEvent
    public static void handleScroll(InputEvent.MouseScrollEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() == TItems.DEBUG.get()) {
            event.setCanceled(true);
            if (Minecraft.func_71410_x().field_71439_g.func_225608_bj_()) {
                ((DebugItem)TItems.DEBUG.get()).width = ((DebugItem)TItems.DEBUG.get()).height = (float)((double)((DebugItem)TItems.DEBUG.get()).height + (event.getScrollDelta() > 0.0 ? 0.0625 : -0.0625));
            } else {
                ((DebugItem)TItems.DEBUG.get()).offsetY = ((DebugItem)TItems.DEBUG.get()).offsetY + (event.getScrollDelta() > 0.0 ? 0.0625 : -0.0625);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlayPost(RenderGameOverlayEvent.Post event) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int scaledWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        int scaledHeight = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        MatrixStack matrixStack = event.getMatrixStack();
        PlayerEntity player = ClientHelper.getClientPlayer();
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            TRenderHelper.drawPlayerCapabilityText(player, matrixStack, fr, scaledWidth, scaledHeight);
        }
    }

    @SubscribeEvent
    public static void onMove(InputUpdateEvent update) {
        LivingEntity liv = update.getEntityLiving();
        if (liv.field_70170_p.func_234923_W_() == TDimensions.SPACE_DIM) {
            if (update.getMovementInput().field_228350_h_) {
                if (liv.func_213322_ci().field_72448_b > -0.1) {
                    liv.func_213317_d(liv.func_213322_ci().func_178786_a(0.0, 0.1, 0.0));
                }
            } else if (update.getMovementInput().field_78901_c && liv.func_213322_ci().field_72448_b < 0.1) {
                liv.func_213317_d(update.getEntityLiving().func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
            }
        }
    }

    @SubscribeEvent
    public static void onKey(InputEvent.KeyInputEvent event) {
        if (TClientRegistry.SNAP_KEY.func_151468_f()) {
            Network.sendToServer(new SnapMessage());
        }
        if (TClientRegistry.RELOAD_GUN.func_151468_f()) {
            Network.sendToServer(new UpdateLaserGun(new ItemStack((IItemProvider)TItems.EARTHSHOCK_GUN.get())));
        }
    }

    @SubscribeEvent
    public static void onDimLightMapUpdate(DimensionLightMapModificationEvent event) {
        if (WorldHelper.areDimensionTypesSame(event.getWorld(), TDimensions.DimensionTypes.TARDIS_TYPE)) {
            float[] colors = new float[3];
            TileEntity te = event.getWorld().func_175625_s(TardisHelper.TARDIS_POS);
            if (te instanceof ConsoleTile) {
                ConsoleTile console = (ConsoleTile)te;
                if (((ConsoleTile)te).getInteriorManager().isAlarmOn()) {
                    colors[0] = 1.0f;
                    colors[1] = event.getLightMapColors().func_195900_b() * 1.0f - (float)Math.sin((double)event.getWorld().func_82737_E() * 0.1) * 0.5f;
                    colors[2] = event.getLightMapColors().func_195902_c() * 1.0f - (float)Math.sin((double)event.getWorld().func_82737_E() * 0.1) * 0.5f;
                } else if (console.getEmotionHandler().getMood() <= (double)EmotionHandler.EnumHappyState.SAD.getTreshold()) {
                    colors[0] = event.getLightMapColors().func_195899_a() * 0.4f;
                    colors[1] = event.getLightMapColors().func_195900_b() * 0.4f;
                    colors[2] = event.getLightMapColors().func_195902_c() * 0.75f;
                } else if (console.getEmotionHandler().getMood() >= (double)EmotionHandler.EnumHappyState.HAPPY.getTreshold()) {
                    colors[0] = event.getLightMapColors().func_195899_a() * 1.5f;
                    colors[1] = event.getLightMapColors().func_195900_b() * 1.5f;
                    colors[2] = event.getLightMapColors().func_195902_c() * 1.5f;
                } else {
                    colors[0] = event.getLightMapColors().func_195899_a();
                    colors[1] = event.getLightMapColors().func_195900_b();
                    colors[2] = event.getLightMapColors().func_195902_c();
                }
            } else {
                colors[0] = event.getLightMapColors().func_195899_a();
                colors[1] = event.getLightMapColors().func_195900_b();
                colors[2] = event.getLightMapColors().func_195902_c();
            }
            event.getLightMapColors().set(colors);
        }
    }

    @SubscribeEvent
    public static void onItemTooltipRender(ItemTooltipEvent event) {
        TRenderHelper.handleTooltipRendering(event.getItemStack(), event.getToolTip(), event.getFlags(), event.getPlayer());
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && event.phase == TickEvent.Phase.START) {
            world.getCapability(Capabilities.TARDIS_DATA).ifPresent(ITardisWorldData::tick);
        }
    }
}

