/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap.items.sonic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.items.sonic.ISonic;
import net.tardis.mod.items.SonicItem;
import net.tardis.mod.items.sonicparts.SonicBasePart;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.SyncSonicMessage;
import net.tardis.mod.registries.SonicModeRegistry;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.schematics.Schematics;
import net.tardis.mod.sonic.AbstractSonicMode;
import net.tardis.mod.sonic.ISonicPart;

public class SonicCapability
implements ISonic {
    public static Random RANDOM = new Random();
    private final ItemStack stack;
    private final float maxCharge = 500.0f;
    private SonicBasePart.SonicComponentTypes[] PARTS = new SonicBasePart.SonicComponentTypes[]{SonicBasePart.SonicComponentTypes.MK_2, SonicBasePart.SonicComponentTypes.MK_2, SonicBasePart.SonicComponentTypes.MK_2, SonicBasePart.SonicComponentTypes.MK_2};
    private AbstractSonicMode mode;
    private float charge = 500.0f;
    private float progress = 0.0f;
    private List<Schematic> schematics = new ArrayList<Schematic>();
    private ResourceLocation tardis;
    private int forgeEnergy = -1;

    public SonicCapability(ItemStack stack) {
        this.stack = stack;
        for (ISonicPart.SonicPart value : ISonicPart.SonicPart.values()) {
            this.setSonicPart(SonicBasePart.SonicComponentTypes.MK_2, value);
        }
    }

    public SonicCapability() {
        this.stack = null;
    }

    public static LazyOptional<ISonic> getForStack(ItemStack stack) {
        return stack.getCapability(Capabilities.SONIC_CAPABILITY);
    }

    public static <T extends Enum<?>> T randomEnum(Class<T> clazz) {
        int x = RANDOM.nextInt(((Enum[])clazz.getEnumConstants()).length);
        return (T)((Enum[])clazz.getEnumConstants())[x];
    }

    @Override
    public void setSonicPart(SonicBasePart.SonicComponentTypes type, ISonicPart.SonicPart part) {
        this.PARTS[part.getInvID()] = type;
    }

    @Override
    public SonicBasePart.SonicComponentTypes getSonicPart(ISonicPart.SonicPart part) {
        return this.PARTS[part.getInvID()];
    }

    @Override
    public float getCharge() {
        return this.charge;
    }

    @Override
    public void setCharge(float charge) {
        this.charge = charge;
    }

    @Override
    public float getMaxCharge() {
        return this.maxCharge;
    }

    @Override
    public float progress() {
        return this.progress;
    }

    @Override
    public void setProgress(float progress) {
        this.progress = progress;
    }

    @Override
    public void sync(PlayerEntity player, Hand hand) {
        Network.sendPacketToAll(new SyncSonicMessage(hand, this.serializeNBT(), player.func_110124_au()));
    }

    @Override
    public void setMode(AbstractSonicMode mode) {
        this.mode = mode;
    }

    @Override
    public void setMode(ResourceLocation location) {
        AbstractSonicMode mode = (AbstractSonicMode)SonicModeRegistry.SONIC_MODE_REGISTRY.get().getValue(location);
        this.mode = mode != null ? mode : (AbstractSonicMode)SonicModeRegistry.BLOCK_INTERACT.get();
    }

    @Override
    public AbstractSonicMode getMode() {
        if (this.mode == null) {
            this.mode = (AbstractSonicMode)SonicModeRegistry.BLOCK_INTERACT.get();
        }
        return this.mode;
    }

    @Override
    public void randomiseParts() {
        for (ISonicPart.SonicPart value : ISonicPart.SonicPart.values()) {
            this.setSonicPart(SonicCapability.randomEnum(SonicBasePart.SonicComponentTypes.class), value);
            SonicItem.syncCapability(this.stack);
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("emmiter", this.PARTS[0].getId());
        compoundNBT.func_74768_a("activator", this.PARTS[1].getId());
        compoundNBT.func_74768_a("handle", this.PARTS[2].getId());
        compoundNBT.func_74768_a("end", this.PARTS[3].getId());
        compoundNBT.func_74778_a("mode", this.getMode().getRegistryName().toString());
        compoundNBT.func_74776_a("charge", this.charge);
        compoundNBT.func_74776_a("progress", this.progress);
        compoundNBT.func_74768_a("forge_energy", this.forgeEnergy);
        ListNBT schems = new ListNBT();
        for (Schematic s : this.getSchematics()) {
            if (s == null || s.getId() == null) continue;
            schems.add((Object)StringNBT.func_229705_a_((String)s.getId().toString()));
        }
        compoundNBT.func_218657_a("schematics", (INBT)schems);
        if (this.tardis != null) {
            compoundNBT.func_74778_a("tardis", this.tardis.toString());
        }
        return compoundNBT;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setSonicPart(this.findPartByID(nbt.func_74762_e("emmiter")), ISonicPart.SonicPart.EMITTER);
        this.setSonicPart(this.findPartByID(nbt.func_74762_e("activator")), ISonicPart.SonicPart.ACTIVATOR);
        this.setSonicPart(this.findPartByID(nbt.func_74762_e("handle")), ISonicPart.SonicPart.HANDLE);
        this.setSonicPart(this.findPartByID(nbt.func_74762_e("end")), ISonicPart.SonicPart.END);
        this.setCharge(nbt.func_74760_g("charge"));
        this.setProgress(nbt.func_74760_g("progress"));
        this.setMode(new ResourceLocation(nbt.func_74779_i("mode")));
        this.schematics.clear();
        this.forgeEnergy = nbt.func_74762_e("forge_energy");
        ListNBT schematicList = nbt.func_150295_c("schematics", 8);
        for (INBT schem : schematicList) {
            if (schem == null) continue;
            this.schematics.add(Schematics.SCHEMATIC_REGISTRY.get(new ResourceLocation(((StringNBT)schem).func_150285_a_())));
        }
        if (nbt.func_74764_b("tardis")) {
            this.tardis = new ResourceLocation(nbt.func_74779_i("tardis"));
        }
    }

    public SonicBasePart.SonicComponentTypes findPartByID(int id) {
        for (SonicBasePart.SonicComponentTypes value : SonicBasePart.SonicComponentTypes.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        return SonicBasePart.SonicComponentTypes.MK_1;
    }

    @Override
    public List<Schematic> getSchematics() {
        return this.schematics;
    }

    @Override
    public void addSchematic(Schematic schematic) {
        if (schematic != null) {
            this.schematics.add(schematic);
        }
    }

    @Override
    public int getForgeEnergy() {
        return this.forgeEnergy;
    }

    @Override
    public void setForgeEnergy(int energy) {
        this.forgeEnergy = energy;
    }

    @Override
    public ResourceLocation getTardis() {
        return this.tardis;
    }

    @Override
    public void setTardis(ResourceLocation tardis) {
        this.tardis = tardis;
    }
}

