/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.items.IWatch;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.WatchTimeUpdate;
import net.tardis.mod.tileentities.BrokenExteriorTile;

public class WatchCapability
implements IWatch {
    private static final BlockPos RADIUS = new BlockPos(25, 25, 25);
    private BrokenExteriorTile tile;
    private int variant = 0;

    @Override
    public void tick(World world, Entity ent, int itemSlot) {
        if (this.tile == null || this.tile.func_145837_r() || !this.tile.func_174877_v().func_218141_a((Vector3i)ent.func_233580_cy_(), 25.0)) {
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)ent.func_233580_cy_().func_177973_b((Vector3i)RADIUS), (BlockPos)ent.func_233580_cy_().func_177971_a((Vector3i)RADIUS))) {
                if (!(world.func_175625_s(pos) instanceof BrokenExteriorTile)) continue;
                this.tile = (BrokenExteriorTile)world.func_175625_s(pos);
                break;
            }
        }
        if (!world.field_72995_K && ent instanceof PlayerEntity) {
            this.variant = this.getVariantFromTime((PlayerEntity)ent);
            Network.sendTo(new WatchTimeUpdate(itemSlot, this.variant), (ServerPlayerEntity)ent);
        }
    }

    @Override
    public boolean shouldSpin(Entity ent) {
        return this.tile != null && !this.tile.func_145837_r() && this.tile.func_174877_v().func_218141_a((Vector3i)ent.func_233580_cy_(), 25.0);
    }

    private int getVariantFromTime(PlayerEntity player) {
        ObjectWrapper<Integer> variant = new ObjectWrapper<Integer>(0);
        if (TardisHelper.isInATardis(player)) {
            TardisHelper.getConsoleInWorld(player.func_130014_f_()).ifPresent(cap -> {
                ServerWorld world = player.field_70170_p.func_73046_m().func_71218_a(cap.getCurrentDimension());
                float percent = (float)world.func_72820_D() / 24000.0f;
                variant.setValue((int)Math.ceil((double)percent * 7.0) % 7);
            });
        }
        return variant.getValue();
    }

    @Override
    public int getVariant() {
        return this.variant;
    }

    @Override
    public void setVariant(int variant) {
        this.variant = variant;
    }
}

