/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap.items;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemStackHandler;
import net.tardis.mod.artron.IArtronItemStackBattery;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.items.IVortexCap;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.world.dimensions.TDimensions;

public class VortexCapability
implements IVortexCap {
    private ItemStack stack;
    private ItemStackHandler handler;
    private int index = 0;
    private float dischargeAmount;
    private boolean hasTeleported = false;
    private boolean isOpen = false;
    private boolean used = false;
    private float totalCharge = 0.0f;

    public VortexCapability() {
    }

    public VortexCapability(ItemStack stack) {
        this.stack = stack;
        this.handler = new ItemStackHandler();
    }

    public VortexCapability(ItemStack stack, int size) {
        this.stack = stack;
        this.handler = new ItemStackHandler(size);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("battery_inv", (INBT)this.handler.serializeNBT());
        tag.func_74757_a("has_teleported", this.hasTeleported);
        tag.func_74776_a("total_charge", this.getTotalCurrentCharge());
        tag.func_74776_a("discharge_amount", this.dischargeAmount);
        tag.func_74757_a("used", this.used);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.handler.deserializeNBT(nbt.func_74775_l("battery_inv"));
        this.hasTeleported = nbt.func_74767_n("has_teleported");
        this.totalCharge = nbt.func_74760_g("total_charge");
        this.dischargeAmount = nbt.func_74760_g("discharge_amount");
        this.used = nbt.func_74767_n("used");
    }

    @Override
    public float getShieldHealth() {
        return 0.0f;
    }

    @Override
    public void setShieldHealth(float health) {
    }

    @Override
    public void tick(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            ServerWorld world = serverPlayer.func_71121_q();
            if (this.used) {
                if (world.func_234923_W_() == TDimensions.VORTEX_DIM) {
                    int numSeconds = (Integer)TConfig.SERVER.vmFuelUsageTime.get();
                    ItemStack slotStack = this.handler.getStackInSlot(this.index);
                    if (slotStack.func_77973_b() instanceof IArtronItemStackBattery) {
                        float stackCharge = ((IArtronItemStackBattery)slotStack.func_77973_b()).getCharge(slotStack);
                        if (stackCharge == 0.0f) {
                            this.safetyCheck();
                            slotStack = this.handler.getStackInSlot(this.index);
                        } else if (world.func_82737_E() % (long)(20 * numSeconds) == 0L) {
                            if (stackCharge >= this.dischargeAmount) {
                                ((IArtronItemStackBattery)slotStack.func_77973_b()).discharge(slotStack, this.dischargeAmount);
                            }
                            if (stackCharge < this.dischargeAmount && stackCharge > 0.0f) {
                                ((IArtronItemStackBattery)slotStack.func_77973_b()).discharge(slotStack, this.dischargeAmount);
                            }
                            if (stackCharge == 0.0f) {
                                this.safetyCheck();
                                slotStack = this.handler.getStackInSlot(this.index);
                            }
                        }
                    } else if (!(slotStack.func_77973_b() instanceof IArtronItemStackBattery)) {
                        this.safetyCheck();
                        slotStack = this.handler.getStackInSlot(this.index);
                    }
                    if (player.func_226278_cu_() <= 10.0) {
                        this.hasTeleported = true;
                        this.serializeNBT();
                    }
                }
                if (world != world.func_73046_m().func_71218_a(TDimensions.VORTEX_DIM) && this.hasTeleported) {
                    world.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)TSounds.VM_TELEPORT_DEST.get(), SoundCategory.BLOCKS, 0.25f, 1.0f);
                    serverPlayer.func_184811_cZ().func_185145_a((Item)TItems.VORTEX_MANIP.get(), (Integer)TConfig.SERVER.vmCooldownTime.get() * 20);
                    serverPlayer.getCapability(Capabilities.PLAYER_DATA).ifPresent(playerCap -> {
                        if (playerCap.getDisplacement() > (double)((Integer)TConfig.SERVER.vmTeleportRange.get() / 2)) {
                            ((List)TConfig.SERVER.vmSideEffects.get()).forEach(effect -> serverPlayer.func_195064_c(new EffectInstance(WorldHelper.getEffectFromRL(new ResourceLocation(effect)), (Integer)((List)TConfig.SERVER.vmSideEffectTime.get()).get(((List)TConfig.SERVER.vmSideEffects.get()).indexOf(effect)) * 20, 1, true, true)));
                        }
                    });
                    this.hasTeleported = false;
                    this.used = false;
                    this.serializeNBT();
                }
            }
        }
    }

    public int safetyCheck() {
        this.index = this.index < this.handler.getSlots() - 1 ? this.index + 1 : 0;
        return this.index;
    }

    public float dischargeEnergy(float discharge) {
        float amt = discharge;
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof IArtronItemStackBattery)) continue;
            IArtronItemStackBattery batt = (IArtronItemStackBattery)stack.func_77973_b();
            amt -= batt.discharge(stack, amt);
        }
        return amt;
    }

    @Override
    public int getBatteries() {
        int battCount = 0;
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof IArtronItemStackBattery)) continue;
            ++battCount;
        }
        return battCount;
    }

    @Override
    public float getDischargeAmount() {
        return this.dischargeAmount;
    }

    @Override
    public void setDischargeAmount(float amount) {
        this.dischargeAmount = amount;
    }

    @Override
    public float getTotalCurrentCharge() {
        float charge = 0.0f;
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof IArtronItemStackBattery)) continue;
            charge += ((IArtronItemStackBattery)stack.func_77973_b()).getCharge(stack);
        }
        return charge;
    }

    @Override
    public float getClientTotalCurrentCharge() {
        return this.totalCharge;
    }

    @Override
    public ItemStackHandler getItemHandler() {
        return this.handler;
    }

    @Override
    public boolean getOpen() {
        return this.isOpen;
    }

    @Override
    public void setOpen(boolean open) {
        this.isOpen = open;
    }

    @Override
    public void setTeleported(boolean teleport) {
        this.hasTeleported = teleport;
    }

    @Override
    public boolean wasVMUsed() {
        return this.used;
    }

    @Override
    public void setVmUsed(boolean type) {
        this.used = type;
    }
}

