/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap.items;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.items.VortexCapability;

public interface IVortexCap
extends INBTSerializable<CompoundNBT> {
    public float getShieldHealth();

    public void setShieldHealth(float var1);

    public void tick(PlayerEntity var1);

    public float getDischargeAmount();

    public void setDischargeAmount(float var1);

    public float getTotalCurrentCharge();

    public ItemStackHandler getItemHandler();

    public void setTeleported(boolean var1);

    public float getClientTotalCurrentCharge();

    public int getBatteries();

    public boolean getOpen();

    public void setOpen(boolean var1);

    public boolean wasVMUsed();

    public void setVmUsed(boolean var1);

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        private IVortexCap vortex;

        public Provider(IVortexCap vortex) {
            this.vortex = vortex;
        }

        public Provider(ItemStack stack) {
            this.vortex = new VortexCapability(stack);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == Capabilities.VORTEX_MANIP ? LazyOptional.of(() -> this.vortex) : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.vortex.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.vortex.deserializeNBT((INBT)nbt);
        }
    }

    @Deprecated
    public static class Storage
    implements Capability.IStorage<IVortexCap> {
        public INBT writeNBT(Capability<IVortexCap> capability, IVortexCap instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IVortexCap> capability, IVortexCap instance, Direction side, INBT nbt) {
            instance.deserializeNBT((INBT)((CompoundNBT)nbt));
        }
    }
}

