/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.misc.SpaceTimeCoord;

public interface IRemote
extends INBTSerializable<CompoundNBT> {
    public ResourceLocation getTardis();

    public void setTardis(ResourceLocation var1);

    public SpaceTimeCoord getExteriorLocation();

    public void setExteriorLocation(SpaceTimeCoord var1);

    public double getJourney();

    public void setJourneyTime(double var1);

    public BlockPos getExteriorPos();

    public RegistryKey<World> getExteriorDim();

    public boolean isInFlight();

    public float getFuel();

    public void onClick(World var1, PlayerEntity var2, BlockPos var3);

    public void tick(World var1, Entity var2);

    public void findTardis(World var1);

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        IRemote remote;

        public Provider(IRemote rem) {
            this.remote = rem;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == Capabilities.REMOTE_CAP ? LazyOptional.of(() -> this.remote) : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.remote.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.remote.deserializeNBT((INBT)nbt);
        }
    }

    @Deprecated
    public static class Storage
    implements Capability.IStorage<IRemote> {
        public INBT writeNBT(Capability<IRemote> capability, IRemote instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IRemote> capability, IRemote instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                instance.deserializeNBT((INBT)((CompoundNBT)nbt));
            }
        }
    }
}

