/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap.items;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.subsystem.SubsystemInfo;
import net.tardis.mod.tileentities.ConsoleTile;

public interface IDiagnostic
extends INBTSerializable<CompoundNBT> {
    public ResourceLocation getTardis();

    public void setTardis(ResourceLocation var1);

    public int getPower();

    public ConsoleTile getConsoleTile();

    public List<SubsystemInfo> getSubsystems();

    public float getAngleFromTarget();

    public void tick(LivingEntity var1);

    public void onRightClick(World var1, PlayerEntity var2, Hand var3);

    public boolean getOn();

    public void setOn(boolean var1);

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        LazyOptional<IDiagnostic> opt = LazyOptional.of(() -> loc);

        public Provider(IDiagnostic loc) {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == Capabilities.DIAGNOSTIC ? this.opt : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)((IDiagnostic)this.opt.orElse(null)).serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.opt.ifPresent(cap -> cap.deserializeNBT((INBT)nbt));
        }
    }

    @Deprecated
    public static class Storage
    implements Capability.IStorage<IDiagnostic> {
        public INBT writeNBT(Capability<IDiagnostic> capability, IDiagnostic instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IDiagnostic> capability, IDiagnostic instance, Direction side, INBT nbt) {
            instance.deserializeNBT((INBT)((CompoundNBT)nbt));
        }
    }
}

