/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.ITardisWorldData;
import net.tardis.mod.cap.items.IDiagnostic;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.TardisDiagnosticItem;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.DiagnosticMessage;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.subsystem.SubsystemInfo;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.ArtronUse;
import net.tardis.mod.world.dimensions.TDimensions;

public class DiagnosticToolCapability
implements IDiagnostic {
    private ItemStack stack;
    private ConsoleTile tile;
    private int power;
    private List<SubsystemInfo> subsystems = new ArrayList<SubsystemInfo>();
    private float rotationToTarget;
    private boolean isOn = false;
    private ResourceLocation owner;

    public DiagnosticToolCapability(ItemStack stack) {
        this.stack = stack;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (SubsystemInfo s : this.subsystems) {
            list.add((Object)s.serializeNBT());
        }
        tag.func_218657_a("subsystems", (INBT)list);
        tag.func_74768_a("power", this.power);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.toString());
        }
        tag.func_74776_a("rotation_target", this.rotationToTarget);
        tag.func_74757_a("on", this.isOn);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        ListNBT list = tag.func_150295_c("subsystems", 10);
        this.subsystems.clear();
        for (INBT nbt : list) {
            this.subsystems.add(new SubsystemInfo((CompoundNBT)nbt));
        }
        this.power = tag.func_74762_e("power");
        if (tag.func_74764_b("owner")) {
            this.owner = new ResourceLocation(tag.func_74779_i("owner"));
        }
        this.rotationToTarget = tag.func_74760_g("rotation_target");
        this.isOn = tag.func_74767_n("on");
    }

    @Override
    public ConsoleTile getConsoleTile() {
        if (this.tile == null || this.tile.func_145837_r()) {
            TardisHelper.getConsole(ServerLifecycleHooks.getCurrentServer(), this.owner).ifPresent(t -> {
                this.tile = t;
            });
        }
        return this.tile;
    }

    @Override
    public List<SubsystemInfo> getSubsystems() {
        return this.subsystems;
    }

    @Override
    public void tick(LivingEntity liv) {
        if (!liv.field_70170_p.field_72995_K) {
            if (this.getTardis() == null) {
                return;
            }
            if (liv.field_70170_p.func_82737_E() % 20L == 0L) {
                BlockRayTraceResult block;
                TileEntity te;
                Vector3d pos = liv.func_213303_ch().func_72441_c(0.0, (double)liv.func_70047_e(), 0.0);
                BlockRayTraceResult res = liv.field_70170_p.func_217299_a(new RayTraceContext(pos, pos.func_178787_e(liv.func_70040_Z().func_186678_a(12.0)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)liv));
                if (res instanceof BlockRayTraceResult && (te = liv.field_70170_p.func_175625_s((block = res).func_216350_a())) instanceof ConsoleTile) {
                    this.subsystems.clear();
                    for (Subsystem s : ((ConsoleTile)te).getSubSystems()) {
                        this.subsystems.add(new SubsystemInfo(s));
                    }
                    te.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(cap -> {
                        this.power = cap.getEnergyCap().getEnergyStored();
                    });
                }
                if (this.getConsoleTile() != null && !this.getConsoleTile().func_145837_r()) {
                    this.rotationToTarget = WorldHelper.getAngleBetweenPoints(liv.func_213303_ch(), WorldHelper.vecFromPos((Vector3i)(!WorldHelper.areDimensionTypesSame(liv.field_70170_p, TDimensions.DimensionTypes.TARDIS_TYPE) ? this.getConsoleTile().getCurrentLocation() : this.getConsoleTile().func_174877_v())));
                    float diff = WorldHelper.getFixedRotation(WorldHelper.getFixedRotation(liv.field_70177_z) - WorldHelper.getFixedRotation(this.rotationToTarget));
                    if (diff > 350.0f || diff < 10.0f) {
                        liv.field_70170_p.func_184133_a(null, liv.func_233580_cy_(), (SoundEvent)TSounds.REMOTE_ACCEPT.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        this.isOn = true;
                    } else {
                        this.isOn = false;
                    }
                }
                TardisDiagnosticItem.syncCapability(this.stack);
            }
        }
    }

    @Override
    public ResourceLocation getTardis() {
        return this.owner;
    }

    @Override
    public void setTardis(ResourceLocation owner) {
        this.owner = owner;
        this.update();
    }

    private void update() {
        TardisDiagnosticItem.syncCapability(this.stack);
    }

    @Override
    public int getPower() {
        return this.power;
    }

    @Override
    public void onRightClick(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ConsoleTile console;
        if (!worldIn.field_72995_K && this.owner != null && (console = this.getConsoleTile()) != null) {
            this.subsystems.clear();
            for (Subsystem subsystem : console.getSubSystems()) {
                this.subsystems.add(new SubsystemInfo(subsystem));
            }
            ArrayList uses = Lists.newArrayList();
            for (ArtronUse use : console.getArtronUses().values()) {
                if (!use.isActive()) continue;
                uses.add(new DiagnosticMessage.ArtronUseInfo(use));
            }
            ITardisWorldData iTardisWorldData = (ITardisWorldData)console.func_145831_w().getCapability(Capabilities.TARDIS_DATA).orElse(null);
            int currentEnergyStored = 0;
            int maxEnergyCapacity = 0;
            if (iTardisWorldData != null) {
                currentEnergyStored = iTardisWorldData.getEnergyCap().getEnergyStored();
                maxEnergyCapacity = iTardisWorldData.getEnergyCap().getMaxEnergyStored();
            }
            DiagnosticMessage.ForgeEnergyInfo forgeEnergy = new DiagnosticMessage.ForgeEnergyInfo(currentEnergyStored, maxEnergyCapacity);
            Network.sendTo(new DiagnosticMessage(this.subsystems, console.getPositionInFlight(), uses, forgeEnergy), (ServerPlayerEntity)playerIn);
        }
    }

    @Override
    public float getAngleFromTarget() {
        return this.rotationToTarget;
    }

    @Override
    public boolean getOn() {
        return this.isOn;
    }

    @Override
    public void setOn(boolean on) {
        this.isOn = on;
    }
}

