/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap.entity;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.entity.IPlayerData;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.helper.LandingSystem;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.SyncPlayerMessage;
import net.tardis.mod.world.dimensions.TDimensions;

public class PlayerDataCapability
implements IPlayerData {
    private PlayerEntity player;
    private SpaceTimeCoord coord = SpaceTimeCoord.UNIVERAL_CENTER;
    private double displacement;
    private int shakingTicks = 0;
    private float shakeMagnitude = 1.0f;
    private int countdownTicks = 0;

    public PlayerDataCapability(PlayerEntity ent) {
        this.player = ent;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("coord", (INBT)this.coord.serialize());
        tag.func_74780_a("displacement", this.displacement);
        tag.func_74768_a("shaking_ticks", this.shakingTicks);
        tag.func_74776_a("shake_magnitude", this.shakeMagnitude);
        tag.func_74768_a("countdown_ticks", this.countdownTicks);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("coord")) {
            this.coord = SpaceTimeCoord.deserialize(nbt.func_74775_l("coord"));
        }
        this.displacement = nbt.func_74769_h("displacement");
        this.shakingTicks = nbt.func_74762_e("shaking_ticks");
        if (nbt.func_74764_b("shake_magnitude")) {
            this.shakeMagnitude = nbt.func_74760_g("shake_magnitude");
        }
        this.countdownTicks = nbt.func_74762_e("countdown_ticks");
    }

    @Override
    public SpaceTimeCoord getDestination() {
        return this.coord;
    }

    @Override
    public void setDestination(SpaceTimeCoord coord) {
        this.coord = coord;
    }

    @Override
    public void tick() {
        if (this.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.player;
            if (serverPlayer.func_71121_q() != null && serverPlayer.func_71121_q().func_234923_W_() == TDimensions.VORTEX_DIM && serverPlayer.func_226278_cu_() < 0.0) {
                RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.coord.getDimRL());
                ServerWorld world = this.player.field_70170_p.func_73046_m().func_71218_a(worldKey);
                if (world != null) {
                    if (world.func_234923_W_() == TDimensions.VORTEX_DIM) {
                        ServerWorld worldDest;
                        world = worldDest = this.player.field_70170_p.func_73046_m().func_71218_a(World.field_234918_g_);
                    }
                    BlockPos pos = this.coord.getPos();
                    if (this.coord.getPos().equals((Object)BlockPos.field_177992_a)) {
                        ChunkPos cPos = new ChunkPos(pos);
                        WorldHelper.forceChunkIfNotLoaded(world, cPos, pos);
                        BlockPos safePos = LandingSystem.getTopBlock((World)world, pos);
                        WorldHelper.unForceChunkIfLoaded(world, cPos, pos);
                        pos = safePos;
                    } else {
                        pos = this.coord.getPos();
                    }
                    serverPlayer.field_70143_R = 0.0f;
                    serverPlayer.func_200619_a(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                }
            }
        } else if (this.shakingTicks > 0 && ((Boolean)TConfig.CLIENT.interiorShake.get()).booleanValue()) {
            this.player.field_70177_z = WorldHelper.getFixedRotation(this.player.field_70177_z) + (this.player.func_70681_au().nextFloat() - 0.5f) * this.shakeMagnitude;
            this.player.field_70125_A += (this.player.func_70681_au().nextFloat() - 0.5f) * this.shakeMagnitude;
        }
        if (this.countdownTicks > 0) {
            --this.countdownTicks;
        }
        if (this.shakingTicks > 0) {
            --this.shakingTicks;
        }
    }

    @Override
    public double getDisplacement() {
        return this.displacement;
    }

    @Override
    public void calcDisplacement(BlockPos start, BlockPos finish) {
        this.displacement = Math.sqrt(start.func_177951_i((Vector3i)finish));
    }

    @Override
    public void setShaking(int shakingTicks, float magnitude) {
        this.shakingTicks = shakingTicks;
        this.shakeMagnitude = magnitude;
    }

    @Override
    public int getShaking() {
        return this.shakingTicks;
    }

    @Override
    public void setShaking(int shakingTicks) {
        this.setShaking(shakingTicks, 1.0f);
    }

    @Override
    public void update() {
        if (!this.player.field_70170_p.field_72995_K) {
            Network.sendTo(new SyncPlayerMessage(this.player.func_145782_y(), this.serializeNBT()), (ServerPlayerEntity)this.player);
        }
    }

    @Override
    public void startCountdown(int time) {
        this.countdownTicks = time;
    }

    @Override
    public int getCountdown() {
        return this.countdownTicks;
    }
}

