/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap.entity;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.misc.SpaceTimeCoord;

public interface IPlayerData
extends INBTSerializable<CompoundNBT> {
    public SpaceTimeCoord getDestination();

    public void setDestination(SpaceTimeCoord var1);

    public double getDisplacement();

    public void calcDisplacement(BlockPos var1, BlockPos var2);

    public void setShaking(int var1, float var2);

    public int getShaking();

    public void setShaking(int var1);

    public void startCountdown(int var1);

    public int getCountdown();

    public void tick();

    public void update();

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        IPlayerData data;

        public Provider(IPlayerData data) {
            this.data = data;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == Capabilities.PLAYER_DATA ? LazyOptional.of(() -> this.data) : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.data.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.data.deserializeNBT((INBT)nbt);
        }
    }

    @Deprecated
    public static class Storage
    implements Capability.IStorage<IPlayerData> {
        public INBT writeNBT(Capability<IPlayerData> capability, IPlayerData instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IPlayerData> capability, IPlayerData instance, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                instance.deserializeNBT((INBT)((CompoundNBT)nbt));
            }
        }
    }
}

