/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemStackHandler;
import net.tardis.mod.artron.IArtronItemStackBattery;
import net.tardis.mod.boti.BotiHandler;
import net.tardis.mod.boti.IBotiEnabled;
import net.tardis.mod.boti.WorldShell;
import net.tardis.mod.boti.stores.EntityStorage;
import net.tardis.mod.boti.stores.TileStore;
import net.tardis.mod.cap.ITardisWorldData;
import net.tardis.mod.energy.TardisEnergy;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.misc.AttunementHandler;
import net.tardis.mod.misc.InteriorEffectsHandler;
import net.tardis.mod.misc.TardisNames;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.BOTIEntityMessage;
import net.tardis.mod.network.packets.BOTIMessage;
import net.tardis.mod.network.packets.BOTITileMessage;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.inventory.PanelInventory;

public class TardisWorldCapability
implements ITardisWorldData {
    public PanelInventory northInv;
    public PanelInventory eastInv;
    public PanelInventory southInv;
    public PanelInventory westInv;
    private World world;
    private TardisEnergy power = this.createEnergyCap();
    private ItemStackHandler itemBuffer;
    private String name;
    private BotiHandler botiHandler;
    private AttunementHandler attunementHandler;
    private InteriorEffectsHandler effectsHandler;
    private WorldShell shell;

    public TardisWorldCapability(World world) {
        this.northInv = new PanelInventory(Direction.NORTH, 8);
        this.eastInv = new PanelInventory(Direction.EAST, 5);
        this.southInv = new PanelInventory(Direction.SOUTH, 10);
        this.westInv = new PanelInventory(Direction.WEST, 10);
        this.itemBuffer = new ItemStackHandler(9);
        this.world = world;
        this.botiHandler = new BotiHandler((IBotiEnabled)this, 10);
        this.attunementHandler = new AttunementHandler(() -> this.eastInv, this.world);
        this.effectsHandler = new InteriorEffectsHandler(this.world);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("north_inv", (INBT)this.northInv.serializeNBT());
        tag.func_218657_a("east_inv", (INBT)this.eastInv.serializeNBT());
        tag.func_218657_a("south_inv", (INBT)this.southInv.serializeNBT());
        tag.func_218657_a("west_inv", (INBT)this.westInv.serializeNBT());
        tag.func_218657_a("power", (INBT)this.power.serializeNBT());
        tag.func_218657_a("item_buffer", (INBT)this.itemBuffer.serializeNBT());
        if (this.name != null) {
            tag.func_74778_a("name", this.name);
        }
        this.attunementHandler.serialize(tag);
        tag.func_218657_a("effects_handler", (INBT)this.effectsHandler.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.northInv.deserializeNBT(tag.func_150295_c("north_inv", 10));
        this.eastInv.deserializeNBT(tag.func_150295_c("east_inv", 10));
        this.southInv.deserializeNBT(tag.func_150295_c("south_inv", 10));
        this.westInv.deserializeNBT(tag.func_150295_c("west_inv", 10));
        this.power.deserializeNBT(tag.func_74775_l("power"));
        this.itemBuffer.deserializeNBT(tag.func_74775_l("item_buffer"));
        this.name = tag.func_74764_b("name") ? tag.func_74779_i("name") : TardisNames.getRandomName(this.world.field_73012_v);
        this.attunementHandler.deserialize(tag);
        this.effectsHandler.deserializeNBT(tag.func_74775_l("effects_handler"));
    }

    @Override
    public PanelInventory getEngineInventoryForSide(Direction dir) {
        switch (dir) {
            case EAST: {
                return this.eastInv;
            }
            case SOUTH: {
                return this.southInv;
            }
            case WEST: {
                return this.westInv;
            }
        }
        return this.northInv;
    }

    @Override
    public void tick() {
        float maxTransfer = 0.1f;
        if (!this.world.field_72995_K) {
            TardisHelper.getConsoleInWorld(this.world).ifPresent(console -> {
                PanelInventory inv = this.getEngineInventoryForSide(Direction.EAST);
                for (int i = 0; i < 4; ++i) {
                    ItemStack stack = inv.getStackInSlot(i);
                    if (!(stack.func_77973_b() instanceof IArtronItemStackBattery)) continue;
                    float transfer = console.getArtron() > maxTransfer ? maxTransfer : console.getArtron();
                    float accepted = ((IArtronItemStackBattery)stack.func_77973_b()).charge(stack, transfer);
                    console.setArtron(console.getArtron() - accepted);
                }
            });
        }
        if (!this.world.field_72995_K) {
            TardisHelper.getConsoleInWorld(this.world).ifPresent(console -> {
                if (console.isInFlight()) {
                    this.attunementHandler.tick((ConsoleTile)((Object)console));
                } else if (this.world.func_82737_E() % 20L == 0L) {
                    this.buildBoti();
                }
            });
        }
        if (this.world.field_72995_K && this.shell != null) {
            this.shell.tick(this.world.field_72995_K);
        }
        this.effectsHandler.tick();
        if (!this.world.field_72995_K && this.shell != null) {
            TardisHelper.getConsoleInWorld(this.world).ifPresent(tile -> this.sendBotiEntities(this.world.func_73046_m().func_71218_a(tile.getCurrentDimension()), tile.getCurrentLocation(), this.getOffset((ConsoleTile)((Object)tile))));
        }
    }

    @Override
    public TardisEnergy getEnergyCap() {
        return this.power;
    }

    private TardisEnergy createEnergyCap() {
        return new TardisEnergy(Integer.MAX_VALUE);
    }

    @Override
    public ItemStackHandler getItemBuffer() {
        return this.itemBuffer;
    }

    @Override
    public AttunementHandler getAttunementHandler() {
        return this.attunementHandler;
    }

    @Override
    public InteriorEffectsHandler getInteriorEffectsHandler() {
        return this.effectsHandler;
    }

    @Override
    public WorldShell getBotiWorld() {
        return this.shell;
    }

    @Override
    public void setBotiWorld(WorldShell shell) {
        this.shell = shell;
    }

    @Override
    public BOTIMessage createMessage(WorldShell shell) {
        return new BOTIMessage(shell);
    }

    public void buildBoti() {
        TardisHelper.getConsoleInWorld(this.world).ifPresent(tile -> {
            ServerWorld exteriorWorld = this.world.func_73046_m().func_71218_a(tile.getCurrentDimension());
            this.botiHandler.setExcludedTilePos(tile.getCurrentLocation().func_177984_a());
            this.botiHandler.updateBoti((World)exteriorWorld, tile.getCurrentLocation(), this.getOffset((ConsoleTile)((Object)tile)), false);
            this.shell.setPortalDirection(tile.getTrueExteriorFacingDirection());
            Network.sendToAllInWorld(new BOTIMessage(this.shell), (ServerWorld)this.world);
            this.sendBotiEntities(exteriorWorld, tile.getCurrentLocation(), this.getOffset((ConsoleTile)((Object)tile)));
            for (TileStore tileStore : this.botiHandler.getTileStores()) {
                Network.sendToAllInWorld(new BOTITileMessage(tileStore), (ServerWorld)this.world);
            }
        });
    }

    public BlockPos getOffset(ConsoleTile tile) {
        return BlockPos.field_177992_a.func_177967_a(tile.getTrueExteriorFacingDirection(), 5);
    }

    public void sendBotiEntities(ServerWorld exteriorWorld, BlockPos currentPos, BlockPos offset) {
        this.botiHandler.gatherEntities((World)exteriorWorld, currentPos, offset);
        for (EntityStorage store : this.botiHandler.getEntityStores()) {
            Network.sendToAllInWorld(new BOTIEntityMessage(store), (ServerWorld)this.world);
        }
    }

    @Override
    public String getTARDISName() {
        if (this.name == null || this.name.isEmpty()) {
            this.name = TardisNames.getRandomName(this.world.field_73012_v);
        }
        return this.name;
    }
}

