/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.tardis.mod.cap.ISpaceDimProperties;
import net.tardis.mod.world.dimensions.TDimensions;

public class SpaceDimensionCapability
implements ISpaceDimProperties {
    private RegistryKey<World> world;

    public SpaceDimensionCapability(RegistryKey<World> world) {
        this.world = world;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("world", this.world.func_240901_a_().toString());
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("world")));
    }

    @Override
    public Vector3d modMotion(Entity ent) {
        if (this.world == TDimensions.SPACE_DIM) {
            ent.field_70143_R = 0.0f;
            if (ent instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)ent).field_71135_a.field_147365_f = 0;
            }
        }
        if (this.world == TDimensions.MOON_DIM) {
            if (ent instanceof PlayerEntity && ((PlayerEntity)ent).field_71075_bZ.field_75100_b) {
                return ent.func_213322_ci();
            }
            if (!ent.func_189652_ae()) {
                ent.field_70143_R = (float)((double)ent.field_70143_R - 0.25);
                return ent.func_213322_ci().func_72441_c(0.0, 0.05, 0.0);
            }
            return ent.func_213322_ci();
        }
        if (this.world == World.field_234920_i_) {
            return ent.func_213322_ci();
        }
        return ent.func_213322_ci().func_72441_c(0.0, 0.08, 0.0);
    }

    @Override
    public boolean isZeroG() {
        return this.world == TDimensions.SPACE_DIM || this.world == World.field_234920_i_;
    }

    @Override
    public boolean hasAir() {
        return this.world != TDimensions.SPACE_DIM && this.world != TDimensions.MOON_DIM;
    }
}

