/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.chunk.Chunk;
import net.tardis.mod.cap.IRift;
import net.tardis.mod.tileentities.ConsoleTile;

public class RiftCapability
implements IRift {
    private Chunk chunk;
    private float artron = 0.0f;
    private boolean isRift = false;
    private float maxArtron = 0.0f;

    public RiftCapability(Chunk chunk) {
        this.chunk = chunk;
    }

    @Override
    public float takeArtron(float amt) {
        float given = this.artron >= amt ? amt : this.artron;
        this.artron -= given;
        return given;
    }

    @Override
    public float getRiftEnergy() {
        return this.artron;
    }

    @Override
    public boolean isRift() {
        return this.isRift;
    }

    @Override
    public void setRift(boolean rift) {
        this.isRift = rift;
        if (this.isRift) {
            this.maxArtron = 250 + ConsoleTile.rand.nextInt(750);
        }
        this.chunk.func_76630_e();
    }

    @Override
    public void addEnergy(float energy) {
        if (this.artron < this.maxArtron) {
            this.artron += energy;
            this.chunk.func_76630_e();
        }
        if (this.artron > this.maxArtron) {
            this.artron = this.maxArtron;
        }
    }

    @Override
    public void tick() {
        if (this.isRift()) {
            this.artron += 1.0f;
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("rift", this.isRift);
        tag.func_74776_a("energy", this.artron);
        tag.func_74776_a("max_energy", this.maxArtron);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.isRift = nbt.func_74767_n("rift");
        this.maxArtron = nbt.func_74760_g("max_energy");
        this.artron = nbt.func_74760_g("energy");
    }
}

