/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.IMissionCap;
import net.tardis.mod.cap.ITickableMission;
import net.tardis.mod.missions.MiniMission;
import net.tardis.mod.missions.MiniMissionType;
import net.tardis.mod.registries.MissionRegistry;

public class MissionWorldCapability
implements IMissionCap {
    private World world;
    private List<MiniMission> missions = Lists.newArrayList();

    public MissionWorldCapability(World world) {
        this.world = world;
    }

    @Override
    @Nullable
    public MiniMission getMissionForPos(BlockPos pos) {
        for (MiniMission mission : this.missions) {
            if (!mission.getPos().func_218141_a((Vector3i)pos, (double)mission.getRange())) continue;
            return mission;
        }
        return null;
    }

    @Override
    public void addMission(MiniMission mission) {
        this.missions.add(mission);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (MiniMission mis : this.missions) {
            CompoundNBT misTag = mis.serializeNBT();
            misTag.func_74778_a("registry_name", mis.getType().getRegistryName().toString());
            list.add((Object)misTag);
        }
        tag.func_218657_a("missions", (INBT)list);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.missions.clear();
        ListNBT list = tag.func_150295_c("missions", 10);
        for (INBT nbt : list) {
            CompoundNBT comp = (CompoundNBT)nbt;
            ResourceLocation key = new ResourceLocation(comp.func_74779_i("registry_name"));
            MiniMissionType missionType = (MiniMissionType)MissionRegistry.MISSION_REGISTRY.get().getValue(key);
            if (missionType == null) continue;
            MiniMission mission = missionType.create(this.world, BlockPos.field_177992_a, 0);
            mission.deserializeNBT(comp);
            this.missions.add(mission);
        }
    }

    @Override
    public void tick(World world) {
        if (!world.func_201670_d()) {
            ServerWorld serv = (ServerWorld)world;
            for (MiniMission m : this.missions) {
                if (m instanceof ITickableMission) {
                    ((ITickableMission)((Object)m)).tick((World)serv);
                }
                if (world.field_72995_K) continue;
                world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                    for (UUID entID : Lists.newArrayList(m.getTrackingPlayers())) {
                        ServerPlayerEntity ent = world.func_73046_m().func_184103_al().func_177451_a(entID);
                        if (!(ent instanceof ServerPlayerEntity) || !m.isMissionComplete() && ent.func_70089_S() && m.isInsideArea((Entity)ent) || !m.getTrackingPlayers().contains(ent.func_110124_au())) continue;
                        m.removeTrackingPlayer(ent);
                    }
                    for (ServerPlayerEntity player : serv.func_217369_A()) {
                        if (m.getTrackingPlayers().contains(player.func_110124_au()) || m.isMissionComplete() || !m.isInsideArea((Entity)player)) continue;
                        m.addTrackingPlayer(player);
                    }
                }));
            }
        }
    }

    @Override
    public List<MiniMission> getAllMissions() {
        return Collections.unmodifiableList(this.missions);
    }

    public void setMissions(List<MiniMission> missions) {
        this.missions.clear();
        this.missions.addAll(missions);
    }
}

