/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.tardis.mod.cap.ILightCap;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.properties.TardisBlockProperties;
import net.tardis.mod.tileentities.ConsoleTile;

public class LightCapability
implements ILightCap {
    private List<BlockPos> lights = new ArrayList<BlockPos>();
    private Chunk chunk;
    private int lightLevel = 0;

    public LightCapability(Chunk chunk) {
        this.chunk = chunk;
    }

    public LightCapability() {
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (BlockPos pos : this.lights) {
            list.add((Object)LongNBT.func_229698_a_((long)pos.func_218275_a()));
        }
        tag.func_218657_a("light", (INBT)list);
        tag.func_74768_a("light_level", this.lightLevel);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT list = nbt.func_150295_c("light", 4);
        for (INBT pos : list) {
            this.lights.add(BlockPos.func_218283_e((long)((LongNBT)pos).func_150291_c()));
        }
        this.lightLevel = nbt.func_74762_e("light_level");
    }

    @Override
    public List<BlockPos> getLightPoses() {
        return this.lights;
    }

    @Override
    public void addLightPos(BlockPos pos) {
        BlockState state;
        this.lights.add(pos);
        if (!this.chunk.func_177412_p().field_72995_K && (state = this.chunk.func_177412_p().func_180495_p(pos)).func_235901_b_((Property)TardisBlockProperties.LIGHT)) {
            this.chunk.func_177412_p().func_175656_a(pos, (BlockState)state.func_206870_a((Property)TardisBlockProperties.LIGHT, (Comparable)Integer.valueOf(this.lightLevel)));
        }
    }

    @Override
    public void onLoad() {
        TileEntity te;
        if (this.chunk.func_177412_p().func_175667_e(TardisHelper.TARDIS_POS) && (te = this.chunk.func_177412_p().func_175625_s(TardisHelper.TARDIS_POS)) instanceof ConsoleTile) {
            this.setLight(((ConsoleTile)te).getInteriorManager().getLight());
        }
    }

    @Override
    public void setLight(int level) {
        if (this.lightLevel != level) {
            for (BlockPos pos : this.lights) {
                BlockState state = this.chunk.func_177412_p().func_180495_p(pos);
                if (!state.func_235901_b_((Property)TardisBlockProperties.LIGHT)) continue;
                this.chunk.func_177412_p().func_180501_a(pos, (BlockState)state.func_206870_a((Property)TardisBlockProperties.LIGHT, (Comparable)Integer.valueOf(level)), 3);
            }
            this.lightLevel = level;
        }
    }
}

