/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.tardis.mod.boti.IBotiEnabled;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.TardisWorldCapability;
import net.tardis.mod.energy.TardisEnergy;
import net.tardis.mod.misc.AttunementHandler;
import net.tardis.mod.misc.InteriorEffectsHandler;
import net.tardis.mod.tileentities.inventory.PanelInventory;

public interface ITardisWorldData
extends INBTSerializable<CompoundNBT>,
IBotiEnabled {
    public PanelInventory getEngineInventoryForSide(Direction var1);

    public TardisEnergy getEnergyCap();

    public ItemStackHandler getItemBuffer();

    public AttunementHandler getAttunementHandler();

    public InteriorEffectsHandler getInteriorEffectsHandler();

    public String getTARDISName();

    public void tick();

    @Deprecated
    public static class TardisWorldStorage
    implements Capability.IStorage<ITardisWorldData> {
        public INBT writeNBT(Capability<ITardisWorldData> capability, ITardisWorldData instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<ITardisWorldData> capability, ITardisWorldData instance, Direction side, INBT nbt) {
            instance.deserializeNBT((INBT)((CompoundNBT)nbt));
        }
    }

    public static class TardisWorldProvider
    implements ICapabilitySerializable<CompoundNBT> {
        private final LazyOptional<ITardisWorldData> holder;
        private ITardisWorldData data;

        public TardisWorldProvider(World world) {
            this.data = new TardisWorldCapability(world);
            this.holder = LazyOptional.of(() -> this.data);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == Capabilities.TARDIS_DATA ? this.holder.cast() : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.data.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.data.deserializeNBT((INBT)nbt);
        }
    }
}

