/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.cap.Capabilities;

public interface ISpaceDimProperties
extends INBTSerializable<CompoundNBT> {
    public Vector3d modMotion(Entity var1);

    public boolean isZeroG();

    default public boolean hasAir() {
        return true;
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        LazyOptional<ISpaceDimProperties> opt = LazyOptional.of(() -> loc);

        public Provider(ISpaceDimProperties loc) {
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == Capabilities.SPACE_DIM_PROPERTIES ? this.opt : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)((ISpaceDimProperties)this.opt.orElse(null)).serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.opt.ifPresent(cap -> cap.deserializeNBT((INBT)nbt));
        }
    }

    @Deprecated
    public static class Storage
    implements Capability.IStorage<ISpaceDimProperties> {
        public INBT writeNBT(Capability<ISpaceDimProperties> capability, ISpaceDimProperties instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<ISpaceDimProperties> capability, ISpaceDimProperties instance, Direction side, INBT nbt) {
            instance.deserializeNBT((INBT)((CompoundNBT)nbt));
        }
    }
}

