/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.artron.IArtronProducer;
import net.tardis.mod.cap.Capabilities;

public interface IRift
extends IArtronProducer,
INBTSerializable<CompoundNBT> {
    public void addEnergy(float var1);

    public float getRiftEnergy();

    public boolean isRift();

    public void setRift(boolean var1);

    public void tick();

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        final IRift rift;
        final LazyOptional<IRift> provide;

        public Provider(IRift rift) {
            this.rift = rift;
            this.provide = LazyOptional.of(() -> this.rift);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == Capabilities.RIFT ? this.provide.cast() : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.rift.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.rift.deserializeNBT((INBT)nbt);
        }
    }

    @Deprecated
    public static class Storage
    implements Capability.IStorage<IRift> {
        public INBT writeNBT(Capability<IRift> capability, IRift instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IRift> capability, IRift instance, Direction side, INBT nbt) {
            instance.deserializeNBT((INBT)((CompoundNBT)nbt));
        }
    }
}

