/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.missions.MiniMission;

public interface IMissionCap
extends INBTSerializable<CompoundNBT> {
    @Nullable
    public MiniMission getMissionForPos(BlockPos var1);

    public void addMission(MiniMission var1);

    public List<MiniMission> getAllMissions();

    public void tick(World var1);

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        private final LazyOptional<IMissionCap> holder;
        private IMissionCap cap;

        public Provider(IMissionCap cap) {
            this.cap = cap;
            this.holder = LazyOptional.of(() -> cap);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == Capabilities.MISSION ? this.holder.cast() : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.cap.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.cap.deserializeNBT((INBT)nbt);
        }
    }

    @Deprecated
    public static class Storage
    implements Capability.IStorage<IMissionCap> {
        public INBT writeNBT(Capability<IMissionCap> capability, IMissionCap instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IMissionCap> capability, IMissionCap instance, Direction side, INBT nbt) {
            instance.deserializeNBT((INBT)((CompoundNBT)nbt));
        }
    }
}

