/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.tardis.mod.Tardis;
import net.tardis.mod.cap.IChunkLoader;

public class ChunkLoaderCapability
implements IChunkLoader {
    @Nullable
    private final ServerWorld world;
    private Long2IntMap refCount = new Long2IntOpenHashMap();
    private LongSet loadedSet = new LongOpenHashSet();
    private boolean isChunkLoading = false;

    public ChunkLoaderCapability(@Nullable ServerWorld world) {
        this.refCount.defaultReturnValue(Integer.MIN_VALUE);
        this.world = world;
    }

    @Override
    public void add(BlockPos pos) {
        long block = pos.func_218275_a();
        if (!this.loadedSet.contains(block)) {
            long chunk = this.toChunk(pos);
            int ref = this.refCount.get(chunk);
            if (ref == Integer.MIN_VALUE) {
                if (!this.isChunkLoading) {
                    this.force(pos);
                }
                ref = 1;
            } else {
                ++ref;
            }
            this.refCount.put(chunk, ref);
            this.loadedSet.add(block);
        }
    }

    @Override
    public void remove(BlockPos pos) {
        if (this.loadedSet.remove(pos.func_218275_a())) {
            long chunk = this.toChunk(pos);
            int ref = this.refCount.get(chunk);
            if (ref == Integer.MIN_VALUE || --ref <= 0) {
                if (!this.isChunkLoading) {
                    this.unforce(pos);
                }
                this.refCount.remove(chunk);
            } else {
                this.refCount.put(chunk, ref);
            }
        }
    }

    @Override
    public boolean contains(BlockPos pos) {
        return this.loadedSet.contains(pos.func_218275_a());
    }

    private final long toChunk(BlockPos pos) {
        return ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
    }

    private void force(BlockPos pos) {
        this.forceload(pos, false, true);
    }

    private void unforce(BlockPos pos) {
        this.forceload(pos, false, true);
    }

    private void forceload(BlockPos pos, boolean force, boolean ticking) {
        if (this.world == null || this.world.func_73046_m() == null) {
            return;
        }
        ChunkPos cPos = new ChunkPos(pos);
        ForgeChunkManager.forceChunk((ServerWorld)this.world, (String)"tardis", (BlockPos)pos, (int)cPos.field_77276_a, (int)cPos.field_77275_b, (boolean)force, (boolean)ticking);
        Tardis.LOGGER.debug("Chunk Loader Capability: Attempting to {} chunk ticket. Pos: {} World: {}", (Object)(force ? "add" : "remove"), (Object)pos, (Object)this.world.func_234923_W_().func_240901_a_());
    }

    @Deprecated
    public static class LoaderStorage
    implements Capability.IStorage<IChunkLoader> {
        public INBT writeNBT(Capability<IChunkLoader> capability, IChunkLoader instance, Direction side) {
            if (!(instance instanceof ChunkLoaderCapability)) {
                return null;
            }
            ChunkLoaderCapability list = (ChunkLoaderCapability)instance;
            long[] data = new long[list.loadedSet.size()];
            int idx = 0;
            LongIterator longIterator = list.loadedSet.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                data[idx++] = l;
            }
            return new LongArrayNBT(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readNBT(Capability<IChunkLoader> capability, IChunkLoader instance, Direction side, INBT nbt) {
            if (!(instance instanceof ChunkLoaderCapability) || !(nbt instanceof LongArrayNBT)) {
                return;
            }
            ChunkLoaderCapability list = (ChunkLoaderCapability)instance;
            list.isChunkLoading = true;
            list.refCount.clear();
            list.loadedSet.clear();
            try {
                for (long l : ((LongArrayNBT)nbt).func_197652_h()) {
                    list.add(BlockPos.func_218283_e((long)l));
                }
                if (list.world != null) {
                    list.world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                        LongIterator longIterator = list.refCount.keySet().iterator();
                        while (longIterator.hasNext()) {
                            long l = (Long)longIterator.next();
                            ChunkPos chunk = new ChunkPos(l);
                            list.force(new BlockPos(chunk.field_77276_a << 4, 0, chunk.field_77275_b << 4));
                        }
                    }));
                }
            }
            finally {
                list.isChunkLoading = false;
            }
        }
    }
}

