/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.boti.stores;

import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.tardis.mod.boti.stores.AbstractEntityStorage;
import net.tardis.mod.boti.stores.PlayerEntityStorage;

public class EntityStorage
extends AbstractEntityStorage {
    public EntityStorageTypes storeType;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public double posX;
    public double posY;
    public double posZ;
    public float yaw;
    public float pitch;
    public float limbSwing = 0.0f;
    public float limbSwingAmount = 0.0f;
    public ResourceLocation type;
    public UUID id;
    public CompoundNBT data;
    public boolean isSneaking;
    public boolean isAlive;
    private int lastUpdatedTime = 40;
    private boolean removed = false;
    Entity entity;

    public EntityStorage(Entity e) {
        if (!e.func_70089_S()) {
            this.isAlive = false;
            this.id = e.func_110124_au();
            this.entity = null;
            return;
        }
        this.posX = e.func_226277_ct_();
        this.posY = e.func_226278_cu_();
        this.posZ = e.func_226281_cx_();
        this.yaw = e.field_70177_z;
        this.pitch = e.field_70125_A;
        if (e instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)e;
            this.limbSwing = livingEntity.field_184619_aG;
            this.limbSwingAmount = livingEntity.field_70721_aZ;
        }
        this.id = e.func_110124_au();
        this.type = e.func_200600_R().getRegistryName();
        this.data = e.serializeNBT();
        this.isSneaking = e.func_225608_bj_();
        this.isAlive = e.func_70089_S();
        this.entity = e;
    }

    public EntityStorage(PacketBuffer buf) {
        this.decode(buf);
    }

    private EntityStorage(UUID id) {
        this.id = id;
        this.isAlive = false;
        this.entity = null;
    }

    public void setStoreType(EntityStorageTypes type) {
        this.storeType = type;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.id);
        buf.writeBoolean(this.isAlive);
        if (!this.isAlive) {
            return;
        }
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeFloat(this.limbSwing);
        buf.writeFloat(this.limbSwingAmount);
        buf.func_192572_a(this.type);
        buf.func_150786_a(this.data);
        buf.writeBoolean(this.isSneaking);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.id = buf.func_179253_g();
        this.isAlive = buf.readBoolean();
        if (!this.isAlive) {
            return;
        }
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.yaw = buf.readFloat();
        this.pitch = buf.readFloat();
        this.limbSwing = buf.readFloat();
        this.limbSwingAmount = buf.readFloat();
        this.type = buf.func_192575_l();
        this.data = buf.func_150793_b();
        this.isSneaking = buf.readBoolean();
    }

    public void updateEntity(EntityStorage store) {
        this.combine(store);
        this.updateEntity();
        this.lastUpdatedTime = 40;
    }

    public void updateEntity() {
        if (this.entity != null) {
            if (this.data != null) {
                this.entity.deserializeNBT(this.data);
            }
            this.entity.field_70142_S = this.entity.field_70169_q = this.prevPosX;
            this.entity.field_70137_T = this.entity.field_70167_r = this.prevPosY;
            this.entity.field_70136_U = this.entity.field_70166_s = this.prevPosZ;
            this.entity.func_70107_b(this.posX, this.posY, this.posZ);
            this.entity.field_70126_B = this.yaw;
            this.entity.field_70127_C = this.pitch;
            this.entity.field_70177_z = this.yaw;
            this.entity.field_70125_A = this.pitch;
            this.entity.func_226284_e_(this.isSneaking);
        }
    }

    public void combine(EntityStorage store) {
        this.type = store.type;
        this.data = store.data;
        this.id = store.id;
        this.pitch = store.pitch;
        this.yaw = store.yaw;
        this.posX = store.posX;
        this.posY = store.posY;
        this.posZ = store.posZ;
        this.isSneaking = store.isSneaking;
        this.isAlive = store.isAlive;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getOrCreateEntity(World world) {
        if (this.entity != null) {
            return this.getEntity();
        }
        return this.create(world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity create(World world) {
        try {
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(this.type);
            if (type != null) {
                this.entity = type.func_200721_a(world);
                this.entity.deserializeNBT(this.data);
                return this.entity;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    public Vector3d createPosVec() {
        return new Vector3d(this.posX, this.posY, this.posZ);
    }

    public void tick() {
        if (this.entity != null) {
            this.entity.func_70071_h_();
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public EntityStorageTypes getStoreType() {
        if (this.storeType == null) {
            this.storeType = EntityStorageTypes.NORMAL;
        }
        return this.storeType;
    }

    public static EntityStorage createDeadStore(UUID id) {
        return new EntityStorage(id);
    }

    public static enum EntityStorageTypes {
        NORMAL(buf -> new EntityStorage((PacketBuffer)buf)),
        PLAYER(buf -> new PlayerEntityStorage((PacketBuffer)buf));

        Function<PacketBuffer, EntityStorage> factory;

        private EntityStorageTypes(Function<PacketBuffer, EntityStorage> factory) {
            this.factory = factory;
        }

        public EntityStorage create(PacketBuffer buf) {
            return this.factory.apply(buf);
        }
    }
}

