/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.boti.stores;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.tardis.mod.Tardis;
import org.apache.logging.log4j.Logger;

public class BlockStore {
    private BlockState state = Blocks.field_150350_a.func_176223_P();
    private FluidState fluidState = Fluids.field_204541_a.func_207188_f();
    private int lightVal = 0;
    private int skyLightLevel = 0;

    public BlockStore(BlockState state, int lightValue, int sktLight) {
        this.state = state;
        this.lightVal = lightValue;
        this.skyLightLevel = sktLight;
    }

    public BlockStore(BlockState state, int lightValue, int skyLight, FluidState fluidState) {
        this(state, lightValue, skyLight);
        this.fluidState = fluidState;
    }

    public BlockStore(PacketBuffer buf) {
        this.decode(buf);
    }

    public BlockStore(World world, BlockPos pos) {
        this(world.func_180495_p(pos), Math.max(world.func_72863_F().func_212863_j_().func_215569_a(LightType.BLOCK).func_215611_b(pos), world.func_180495_p(pos).getLightValue((IBlockReader)world, pos)), world.func_226658_a_(LightType.SKY, pos), world.func_204610_c(pos));
    }

    public BlockState getState() {
        return this.state;
    }

    public int getLight() {
        return this.lightVal;
    }

    public int getSkyLight() {
        return this.skyLightLevel;
    }

    public FluidState getFluidState() {
        return this.fluidState;
    }

    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("state", (INBT)NBTUtil.func_190009_a((BlockState)this.state));
        nbt.func_74768_a("light", this.lightVal);
        FluidState.field_237213_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.fluidState).resultOrPartial(arg_0 -> ((Logger)Tardis.LOGGER).error(arg_0)).ifPresent(data -> nbt.func_218657_a("fluid_state", data));
        return nbt;
    }

    public static BlockStore deserialize(CompoundNBT tag) {
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("state"));
        int light = tag.func_74762_e("light");
        int skyLight = tag.func_74762_e("sky_light");
        Optional result = FluidState.field_237213_a_.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tag.func_74781_a("fluid_state")).resultOrPartial(arg_0 -> ((Logger)Tardis.LOGGER).error(arg_0));
        FluidState fluidState = (FluidState)((Pair)result.get()).getFirst();
        if (fluidState != null) {
            return new BlockStore(state, light, skyLight, fluidState);
        }
        return new BlockStore(state, light, skyLight);
    }

    public void encode(PacketBuffer buf) {
        buf.func_150786_a(NBTUtil.func_190009_a((BlockState)this.state));
        buf.writeInt(this.lightVal);
        buf.writeInt(this.skyLightLevel);
        buf.func_150786_a(FluidState.field_237213_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.fluidState).result().orElse(new CompoundNBT()));
    }

    public void decode(PacketBuffer buf) {
        this.state = NBTUtil.func_190008_d((CompoundNBT)buf.func_150793_b());
        this.lightVal = buf.readInt();
        this.skyLightLevel = buf.readInt();
        FluidState.field_237213_a_.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)buf.func_150793_b()).result().ifPresent(data -> {
            this.fluidState = (FluidState)data.getFirst();
        });
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockStore)) {
            return false;
        }
        BlockStore other = (BlockStore)obj;
        return other.fluidState != null ? this.state.equals(other.state) && this.fluidState.equals(other.fluidState) : this.state.equals(other.state);
    }

    public int hashCode() {
        return this.state.hashCode();
    }
}

