/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.boti;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tardis.mod.boti.BotiChunk;
import net.tardis.mod.boti.BotiWorld;
import net.tardis.mod.boti.stores.BlockStore;
import net.tardis.mod.boti.stores.EntityStorage;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.client.renderers.boti.BOTIRenderer;

public class WorldShell
implements IBlockDisplayReader {
    private static Object botiWorld;
    private final int maxRadiusRange = 10;
    private HashMap<BlockPos, BlockStore> blocks = new HashMap();
    private HashMap<BlockPos, TileEntity> tileEntities = new HashMap();
    private HashMap<UUID, EntityStorage> entities = Maps.newHashMap();
    private boolean update = true;
    private BlockPos offset = BlockPos.field_177992_a;
    private RegistryKey<Biome> biome = Biomes.field_235250_aA_;
    private RegistryKey<DimensionType> type;
    private Direction portalFacing = Direction.NORTH;
    private Biome cachedBiome;

    public WorldShell(BlockPos offset, RegistryKey<DimensionType> type, RegistryKey<Biome> biome) {
        this.offset = offset.func_185334_h();
        this.type = type;
        this.biome = biome;
    }

    public WorldShell(BlockPos offset, World world) {
        this.offset = offset.func_185334_h();
        this.type = world.func_241828_r().func_243612_b(Registry.field_239698_ad_).func_230519_c_((Object)world.func_230315_m_()).orElse(DimensionType.field_235999_c_);
        this.biome = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)world.func_226691_t_(offset)).orElse(Biomes.field_76767_f);
    }

    public static WorldShell readFromBuffer(PacketBuffer buffer) {
        WorldShell shell = new WorldShell(buffer.func_179259_c(), (RegistryKey<DimensionType>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)buffer.func_192575_l()), (RegistryKey<Biome>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)buffer.func_192575_l()));
        shell.setPortalDirection(Direction.func_176731_b((int)buffer.readInt()));
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            shell.put(buffer.func_179259_c(), new BlockStore(buffer));
        }
        shell.sortBlocks();
        return shell;
    }

    public void writeToBuffer(PacketBuffer buf) {
        buf.func_179255_a(this.offset);
        buf.func_192572_a(this.type.func_240901_a_());
        buf.func_192572_a(this.biome.func_240901_a_());
        buf.writeInt(this.portalFacing.func_176736_b());
        buf.writeInt(this.blocks.size());
        for (Map.Entry<BlockPos, BlockStore> entry : this.getBlockMap().entrySet()) {
            buf.func_179255_a(entry.getKey());
            entry.getValue().encode(buf);
        }
    }

    public void put(BlockPos pos, BlockStore store) {
        this.blocks.put(pos, store);
    }

    public BlockStore get(BlockPos pos) {
        return this.blocks.get(pos);
    }

    public Map<BlockPos, BlockStore> getBlockMap() {
        return this.blocks;
    }

    public void setMap(HashMap<BlockPos, BlockStore> newShell) {
        this.blocks.clear();
        this.blocks.putAll(newShell);
        this.sortBlocks();
    }

    public void setOffset(BlockPos offset) {
        this.offset = offset;
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.tileEntities.get(pos);
    }

    public BlockState func_180495_p(BlockPos pos) {
        return this.get(pos) != null ? this.get(pos).getState() : Blocks.field_150350_a.func_176223_P();
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.get(pos) != null ? this.get(pos).getState().func_204520_s() : Fluids.field_204541_a.func_207188_f();
    }

    public void setBiome(RegistryKey<Biome> b) {
        this.biome = b;
    }

    public Biome getBiome(World world) {
        if (this.cachedBiome == null) {
            this.cachedBiome = (Biome)world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230516_a_(this.biome);
        }
        return this.cachedBiome;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public BotiWorld getWorld() {
        DimensionType shellDimType = (DimensionType)ClientHelper.getClientWorldCasted().func_241828_r().func_230520_a_().func_230516_a_(this.type);
        if (botiWorld == null || shellDimType != ((BotiWorld)((Object)botiWorld)).func_230315_m_()) {
            botiWorld = BotiWorld.copy(ClientHelper.getClientWorldCasted(), shellDimType, BOTIRenderer.worldRenderer);
        }
        return (BotiWorld)((Object)botiWorld);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setWorld(BotiWorld world) {
        botiWorld = world;
        for (TileEntity te : this.tileEntities.values()) {
            te.func_226984_a_((World)world, te.func_174877_v());
        }
        for (EntityStorage e : this.getEntities()) {
            e.create((World)world);
        }
    }

    public Map<BlockPos, TileEntity> getTiles() {
        return this.tileEntities;
    }

    public boolean needsUpdate() {
        return this.update;
    }

    public void setNeedsUpdate(boolean update) {
        this.update = update;
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    @Nullable
    public DimensionType getDimensionType() {
        return (DimensionType)this.getWorld().func_241828_r().func_243612_b(Registry.field_239698_ad_).func_243576_d(this.type);
    }

    public void setDimensionType(RegistryKey<DimensionType> type) {
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Collection<EntityStorage> getEntities() {
        return this.entities.values();
    }

    public void tick(boolean isClientSide) {
        if (isClientSide) {
            this.tickWorld();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickWorld() {
        try {
            ArrayList<UUID> removedEntities = new ArrayList<UUID>();
            for (Map.Entry<UUID, EntityStorage> entry : this.entities.entrySet()) {
                entry.getValue().tick();
                if (!entry.getValue().isRemoved()) continue;
                removedEntities.add(entry.getKey());
            }
            for (UUID id : removedEntities) {
                this.entities.remove(id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void combine(WorldShell shell) {
        if (!shell.getBlockMap().isEmpty() && !shell.getBlockMap().equals(this.getBlockMap())) {
            this.blocks.putAll(shell.getBlockMap());
            this.tileEntities.putAll(shell.tileEntities);
            this.entities.putAll(shell.entities);
            this.setNeedsUpdate(true);
            this.portalFacing = shell.getPortalDirection();
            this.sortBlocks();
        }
    }

    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        return 0.0f;
    }

    public WorldLightManager func_225524_e_() {
        return this.getWorld().func_225524_e_();
    }

    public int func_225525_a_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        return 0;
    }

    public void setPortalDirection(Direction dir) {
        this.portalFacing = dir;
    }

    public Direction getPortalDirection() {
        return this.portalFacing;
    }

    public void cullOutOfRangeBlocksInterior() {
        this.cullOutOfRangeBlocks(true);
    }

    public void cullOutOfRangeBlocksExterior() {
        this.cullOutOfRangeBlocks(false);
    }

    public void cullOutOfRangeBlocks(boolean isTardisInteriorWorld) {
        ArrayList positionsToRemove = Lists.newArrayList();
        Direction cullBehindDoorDirection = isTardisInteriorWorld ? this.portalFacing : this.portalFacing.func_176734_d();
        BlockPos posBehindDoor = this.offset.func_177972_a(cullBehindDoorDirection).func_185334_h();
        BlockPos posBehindDoorUp = posBehindDoor.func_177984_a();
        Vector3d doorBehind = new Vector3d((double)posBehindDoor.func_177958_n(), (double)posBehindDoor.func_177956_o(), (double)posBehindDoor.func_177952_p());
        Vector3d doorBehindUp = new Vector3d((double)posBehindDoorUp.func_177958_n(), (double)posBehindDoorUp.func_177956_o(), (double)posBehindDoorUp.func_177952_p());
        BlockPos posFrontOfDoorLeft = this.offset.func_177967_a(this.portalFacing.func_176735_f(), 3);
        BlockPos posBehindDoorRight = posBehindDoor.func_177967_a(this.portalFacing.func_176746_e(), 4).func_177981_b(4);
        AxisAlignedBB doorCull = new AxisAlignedBB(posFrontOfDoorLeft, posBehindDoorRight);
        BlockPos cullToLeftPortalPosition = posBehindDoor.func_177967_a(this.portalFacing.func_176735_f(), this.maxRadiusRange).func_177979_c(8);
        int cullBehindAmount = 10;
        BlockPos cullToRightAndBehindDoorPosition = posBehindDoor.func_177967_a(this.portalFacing.func_176746_e(), this.maxRadiusRange).func_177967_a(cullBehindDoorDirection, cullBehindAmount).func_177981_b(8);
        AxisAlignedBB area = new AxisAlignedBB(cullToLeftPortalPosition, cullToRightAndBehindDoorPosition);
        for (BlockPos pos : this.blocks.keySet()) {
            Vector3d vec = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (!doorCull.func_72318_a(vec) && !vec.equals((Object)doorBehindUp) && !vec.equals((Object)doorBehind) && !area.func_72318_a(vec)) continue;
            positionsToRemove.add(pos);
        }
        for (BlockPos pos : positionsToRemove) {
            this.getBlockMap().remove(pos);
        }
        this.sortBlocks();
    }

    public void buildLighting() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateEntities(List<EntityStorage> entities) {
        for (EntityStorage storage : entities) {
            if (this.entities.containsKey(storage.id)) {
                if (!storage.isAlive) {
                    this.entities.remove(storage.id);
                    return;
                }
                this.entities.get(storage.id).updateEntity(storage);
                Entity entity = storage.getEntity();
                if (entity == null || entity.func_70089_S() && entity.func_233580_cy_().func_218141_a((Vector3i)this.getOffset(), 32.0)) continue;
                this.entities.remove(storage.id);
                continue;
            }
            this.entities.put(storage.id, storage);
        }
    }

    public void addTile(BlockPos pos, TileEntity entity) {
        this.tileEntities.put(pos, entity);
        entity.func_145836_u();
    }

    public void sortBlocks() {
    }

    public int getMaxRadiusRange() {
        return this.maxRadiusRange;
    }

    public void addChunk(BotiChunk chunk) {
        System.out.println("Adding chunk " + chunk);
        for (Map.Entry<BlockPos, BlockStore> store : chunk.getMap().entrySet()) {
            this.blocks.put(store.getKey(), store.getValue());
            System.out.println("Adding block " + store.getValue() + " at " + store.getKey());
        }
        this.setNeedsUpdate(true);
    }
}

