/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.boti;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tardis.mod.boti.BotiWorldProfiler;
import net.tardis.mod.boti.WorldShell;
import net.tardis.mod.boti.stores.BlockStore;
import net.tardis.mod.boti.stores.EntityStorage;
import net.tardis.mod.helper.Helper;

@OnlyIn(value=Dist.CLIENT)
public class BotiWorld
extends ClientWorld {
    public static Supplier<IProfiler> PROFILER = BotiWorldProfiler::new;
    private static RegistryKey<World> DUMMY_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)Helper.createRL("boti"));
    private WorldShell shell;

    public BotiWorld(ClientPlayNetHandler handler, ClientWorld.ClientWorldInfo info, DimensionType dimType, int viewDistance, Supplier<IProfiler> profiler, WorldRenderer worldRenderer, boolean isDebug, long seed) {
        super(Minecraft.func_71410_x().field_71439_g.field_71174_a, Minecraft.func_71410_x().field_71441_e.func_72912_H(), DUMMY_KEY, dimType, 10, PROFILER, worldRenderer, false, seed);
        this.func_72966_v();
    }

    public BotiWorld(RegistryKey<World> world, WorldShell shell, DimensionType dimType, WorldRenderer worldRenderer, long seed) {
        super(Minecraft.func_71410_x().field_71439_g.field_71174_a, Minecraft.func_71410_x().field_71441_e.func_72912_H(), world, dimType, 10, PROFILER, worldRenderer, false, seed);
        this.shell = shell;
        this.shell.setDimensionType((RegistryKey<DimensionType>)((RegistryKey)Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239698_ad_).func_230519_c_((Object)dimType).get()));
    }

    public Iterable<Entity> func_217416_b() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (this.shell == null) {
            return list;
        }
        for (EntityStorage store : this.shell.getEntities()) {
            list.add(store.getOrCreateEntity((World)this));
        }
        return list;
    }

    public Entity func_73045_a(int id) {
        return null;
    }

    public BlockState func_180495_p(BlockPos pos) {
        return this.shell.func_180495_p(pos);
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.shell.func_175625_s(pos);
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.shell.func_204610_c(pos);
    }

    public Biome func_226691_t_(BlockPos pos) {
        return this.shell.getBiome((World)Minecraft.func_71410_x().field_71441_e);
    }

    public int func_201696_r(BlockPos pos) {
        if (this.shell == null) {
            return 0;
        }
        BlockStore store = this.shell.get(pos);
        if (store != null) {
            return LightTexture.func_228451_a_((int)this.shell.getWorld().func_226658_a_(LightType.BLOCK, pos), (int)this.shell.getWorld().func_226658_a_(LightType.SKY, pos));
        }
        return 15;
    }

    public int func_226658_a_(LightType lightTypeIn, BlockPos blockPosIn) {
        if (this.shell == null) {
            return 0;
        }
        BlockStore store = this.shell.get(blockPosIn);
        if (store != null) {
            if (lightTypeIn == LightType.SKY) {
                return store.getSkyLight();
            }
            return store.getLight();
        }
        return lightTypeIn == LightType.SKY ? 15 : 0;
    }

    public void func_217391_K() {
        if (this.shell != null) {
            for (TileEntity te : this.shell.getTiles().values()) {
                if (!(te instanceof ITickableTileEntity)) continue;
                ((ITickableTileEntity)te).func_73660_a();
            }
        }
    }

    public void setShell(WorldShell shell) {
        this.shell = shell;
    }

    public static BotiWorld copy(ClientWorld world, DimensionType type, WorldRenderer renderer) {
        return new BotiWorld(Minecraft.func_71410_x().func_147114_u(), world.func_72912_H(), type, 12, PROFILER, renderer, true, 1234L);
    }
}

