/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.boti;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tardis.mod.boti.BotiChunk;
import net.tardis.mod.boti.IBotiEnabled;
import net.tardis.mod.boti.WorldShell;
import net.tardis.mod.boti.stores.BlockStore;
import net.tardis.mod.boti.stores.EntityStorage;
import net.tardis.mod.boti.stores.PlayerEntityStorage;
import net.tardis.mod.boti.stores.TileStore;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.helper.Helper;

public class BotiHandler {
    private List<TileStore> tileStores = Lists.newArrayList();
    private List<EntityStorage> entityStores = Lists.newArrayList();
    private List<BotiChunk> chunks = Lists.newArrayList();
    private AxisAlignedBB area;
    private BlockPos excludedTilePos = BlockPos.field_177992_a;
    private int excludedEntityID;
    private IBotiEnabled parent;

    public BotiHandler(IBotiEnabled parent) {
        this.parent = parent;
    }

    public BotiHandler(IBotiEnabled parent, AxisAlignedBB area) {
        this(parent);
        this.setArea(area);
    }

    public BotiHandler(IBotiEnabled parent, int diameter) {
        this(parent);
        this.setDiameter(diameter);
    }

    public void setArea(AxisAlignedBB area) {
        this.area = area;
    }

    public void setDiameter(int diameter) {
        this.setArea(AxisAlignedBB.func_241550_g_((double)diameter, (double)diameter, (double)diameter));
    }

    public boolean updateBoti(World world, BlockPos center) {
        return this.updateBoti(world, center, BlockPos.field_177992_a, true);
    }

    public boolean updateBoti(World otherWorld, BlockPos center, BlockPos offset, boolean isTardisInteriorWorld) {
        if (!otherWorld.field_72995_K) {
            if (this.parent.getBotiWorld() == null) {
                this.parent.setBotiWorld(new WorldShell(center, otherWorld));
            }
            if (!this.parent.getBotiWorld().getOffset().equals((Object)center)) {
                this.parent.getBotiWorld().setOffset(center);
            }
            Map<BlockPos, BlockStore> newBlocks = this.gatherBlocks(otherWorld, center, this.area.func_186670_a(offset));
            this.parent.getBotiWorld().getBlockMap().clear();
            this.parent.getBotiWorld().getBlockMap().putAll(newBlocks);
            this.parent.getBotiWorld().cullOutOfRangeBlocks(isTardisInteriorWorld);
            List<EntityStorage> entities = this.gatherEntities(otherWorld, center, offset);
            this.entityStores.clear();
            this.entityStores.addAll(entities);
            return true;
        }
        return false;
    }

    public Map<BlockPos, BlockStore> gatherBlocks(World world, BlockPos pos, AxisAlignedBB area) {
        pos = pos.func_185334_h();
        HashMap<BlockPos, BlockStore> map = new HashMap<BlockPos, BlockStore>();
        this.tileStores.clear();
        int x = (int)Math.floor(area.field_72340_a);
        while ((double)x < area.field_72336_d) {
            int y = (int)Math.floor(area.field_72338_b);
            while ((double)y < area.field_72337_e) {
                int z = (int)Math.floor(area.field_72339_c);
                while ((double)z < area.field_72334_f) {
                    TileEntity tile;
                    BlockPos newPos = pos.func_177982_a(x, y, z);
                    BlockState state = world.func_180495_p(newPos);
                    if (!state.isAir((IBlockReader)world, newPos) && !newPos.equals((Object)this.excludedTilePos) && Helper.canBeInBOTIPacket(state)) {
                        map.put(newPos, new BlockStore(world, newPos));
                    }
                    if ((tile = world.func_175625_s(newPos)) != null && !newPos.equals((Object)this.excludedTilePos) && Helper.canBeInBOTIPacket(tile.func_195044_w())) {
                        this.tileStores.add(new TileStore(newPos, tile));
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return map;
    }

    public List<BotiChunk> gatherChunks(World world, BlockPos pos, AxisAlignedBB area, int chunkSize) {
        ArrayList<BotiChunk> chunks = new ArrayList<BotiChunk>();
        return chunks;
    }

    public BotiChunk gatherChunk(World world, BlockPos start, int size) {
        BotiChunk chunk = new BotiChunk();
        for (int x = start.func_177958_n(); x < start.func_177958_n() + size; ++x) {
            for (int y = start.func_177956_o(); y < start.func_177956_o() + size; ++y) {
                for (int z = start.func_177952_p(); z < start.func_177952_p() + size; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    chunk.addToChunk(pos, new BlockStore(world, pos));
                }
            }
        }
        return chunk;
    }

    public List<EntityStorage> gatherEntities(World world, BlockPos center, BlockPos offset) {
        ArrayList list = Lists.newArrayList();
        AxisAlignedBB box = this.area.func_186670_a(center).func_186670_a(offset);
        for (Entity e : world.func_217357_a(Entity.class, box)) {
            if (e.func_200600_R() == null || e.func_200600_R() == TEntities.CONTROL.get() || e.func_200600_R() == TEntities.CHAIR.get() || e.func_145782_y() == this.excludedEntityID || !Helper.canBeInBOTIPacket(e)) continue;
            if (e instanceof PlayerEntity) {
                list.add(new PlayerEntityStorage((PlayerEntity)e));
                continue;
            }
            list.add(new EntityStorage(e));
        }
        return list;
    }

    public Map<BlockPos, BlockStore> getDiff(Map<BlockPos, BlockStore> original, Map<BlockPos, BlockStore> newList) {
        HashMap diff = Maps.newHashMap();
        for (Map.Entry<BlockPos, BlockStore> entry : newList.entrySet()) {
            if (!original.containsKey(entry.getKey())) {
                diff.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!original.get(entry.getKey()).getState().func_203425_a(entry.getValue().getState().func_177230_c())) {
                diff.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!original.get(entry.getKey()).getState().func_185904_a().equals(entry.getValue().getState().func_185904_a())) {
                diff.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (original.get(entry.getKey()).getState().func_185904_a() != Material.field_151579_a) continue;
            diff.put(entry.getKey(), entry.getValue());
        }
        return diff;
    }

    public BlockPos getExcludedTilePos() {
        return this.excludedTilePos;
    }

    public void setExcludedTilePos(BlockPos pos) {
        this.excludedTilePos = pos.func_185334_h();
    }

    public int getExcludedEntityPos() {
        return this.excludedEntityID;
    }

    public void setExcludedEntityId(int id) {
        this.excludedEntityID = id;
    }

    public List<TileStore> getTileStores() {
        return this.tileStores;
    }

    public List<EntityStorage> getEntityStores() {
        return this.entityStores;
    }

    public List<BotiChunk> getChunks() {
        return this.chunks;
    }

    public IBotiEnabled getBotiEnabledObject() {
        return this.parent;
    }

    public List<BotiChunk> splitIntoChunks(int chunkSize) {
        WorldShell shell = this.parent.getBotiWorld();
        Vector3i min = this.min(shell);
        Vector3i max = this.max(shell);
        Vector3i size = new Vector3i(max.func_177958_n() - min.func_177958_n(), max.func_177956_o() - min.func_177956_o(), max.func_177952_p() - min.func_177952_p());
        ArrayList<BotiChunk> chunks = new ArrayList<BotiChunk>();
        int iterations = (int)Math.ceil((double)size.func_177958_n() / (double)chunkSize);
        int xOffset = 0;
        int yOffset = 0;
        int zOffset = 0;
        for (int i = 0; i < iterations; ++i) {
            BotiChunk chunk = new BotiChunk();
            for (int x = 0; x < chunkSize; ++x) {
                for (int y = 0; y < chunkSize; ++y) {
                    for (int z = 0; z < chunkSize; ++z) {
                        BlockPos pos = new BlockPos(min.func_177958_n() + xOffset * chunkSize + x, min.func_177956_o() + yOffset * chunkSize + y, min.func_177952_p() + zOffset * chunkSize + z);
                        BlockStore store = shell.get(pos);
                        if (store == null || store.getState().func_196958_f()) continue;
                        chunk.addToChunk(pos, store);
                    }
                    ++zOffset;
                }
                ++yOffset;
            }
            ++xOffset;
            chunks.add(chunk);
        }
        return chunks;
    }

    public Vector3i min(WorldShell shell) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (BlockPos pos : shell.getBlockMap().keySet()) {
            minX = Math.min(minX, pos.func_177958_n());
            minY = Math.min(minY, pos.func_177956_o());
            minZ = Math.min(minZ, pos.func_177952_p());
        }
        return new Vector3i(minX, minY, minZ);
    }

    public Vector3i max(WorldShell shell) {
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : shell.getBlockMap().keySet()) {
            maxX = Math.max(maxX, pos.func_177958_n());
            maxY = Math.max(maxY, pos.func_177956_o());
            maxZ = Math.max(maxZ, pos.func_177952_p());
        }
        return new Vector3i(maxX, maxY, maxZ);
    }
}

