/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks.template;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.misc.IItemTooltipProvider;
import net.tardis.mod.properties.Prop;

public class TooltipProviderBlock
extends Block
implements IItemTooltipProvider {
    protected boolean shouldShowTooltips = false;
    protected boolean hasStatisticsTooltips = false;
    protected boolean hasDescriptionTooltips = false;

    public TooltipProviderBlock(AbstractBlock.Properties properties, boolean showTooltips) {
        super(properties);
        this.shouldShowTooltips = showTooltips;
    }

    public TooltipProviderBlock(AbstractBlock.Properties properties) {
        this(properties, false);
    }

    public TooltipProviderBlock() {
        super(Prop.Blocks.BASIC_TECH.get());
    }

    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_190948_a(stack, world, tooltip, flag);
        if (this.shouldShowTooltips()) {
            this.createDefaultTooltips(stack, world, tooltip, flag);
            if (this.hasStatisticsTooltips()) {
                tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_HOLD_SHIFT);
                if (Screen.func_231173_s_()) {
                    tooltip.clear();
                    tooltip.add(0, (ITextComponent)this.func_235333_g_());
                    this.createStatisticTooltips(stack, world, tooltip, flag);
                }
            }
            if (this.hasDescriptionTooltips()) {
                tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_CONTROL);
                if (Screen.func_231172_r_()) {
                    tooltip.clear();
                    tooltip.add(0, (ITextComponent)this.func_235333_g_());
                    this.createDescriptionTooltips(stack, world, tooltip, flag);
                }
            }
        }
    }

    @Override
    public void createStatisticTooltips(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    public void createDescriptionTooltips(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    public void createDefaultTooltips(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    @Override
    public boolean shouldShowTooltips() {
        return this.shouldShowTooltips;
    }

    @Override
    public void setShowTooltips(boolean showTooltips) {
        this.shouldShowTooltips = showTooltips;
    }

    @Override
    public boolean hasStatisticsTooltips() {
        return this.hasStatisticsTooltips;
    }

    @Override
    public void setHasStatisticsTooltips(boolean hasStatisticsTooltips) {
        this.hasStatisticsTooltips = hasStatisticsTooltips;
    }

    @Override
    public boolean hasDescriptionTooltips() {
        return this.hasDescriptionTooltips;
    }

    @Override
    public void setHasDescriptionTooltips(boolean hasDescriptionTooltips) {
        this.hasDescriptionTooltips = hasDescriptionTooltips;
    }
}

