/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks.monitor;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.tardis.mod.blocks.monitor.MonitorBlock;
import net.tardis.mod.helper.VoxelShapeUtils;

public class MonitorSteampunkBlock
extends MonitorBlock {
    public static final VoxelShape NORTH = MonitorSteampunkBlock.createVoxelShape();
    public static final VoxelShape EAST = VoxelShapeUtils.rotate(MonitorSteampunkBlock.createVoxelShape(), Rotation.CLOCKWISE_90);
    public static final VoxelShape SOUTH = VoxelShapeUtils.rotate(MonitorSteampunkBlock.createVoxelShape(), Rotation.CLOCKWISE_180);
    public static final VoxelShape WEST = VoxelShapeUtils.rotate(MonitorSteampunkBlock.createVoxelShape(), Rotation.COUNTERCLOCKWISE_90);
    public static final VoxelShape HANGING_NORTH = MonitorSteampunkBlock.createHangingVoxelShape();
    public static final VoxelShape HANGING_EAST = VoxelShapeUtils.rotate(MonitorSteampunkBlock.createHangingVoxelShape(), Rotation.CLOCKWISE_90);
    public static final VoxelShape HANGING_SOUTH = VoxelShapeUtils.rotate(MonitorSteampunkBlock.createHangingVoxelShape(), Rotation.CLOCKWISE_180);
    public static final VoxelShape HANGING_WEST = VoxelShapeUtils.rotate(MonitorSteampunkBlock.createHangingVoxelShape(), Rotation.COUNTERCLOCKWISE_90);

    public MonitorSteampunkBlock(AbstractBlock.Properties prop, int guiID, double x, double y, double z, double width, double height) {
        super(prop, guiID, x, y, z, width, height);
    }

    public static VoxelShape createVoxelShape() {
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.03125, (double)0.515625, (double)0.171875, (double)0.96875, (double)0.578125, (double)0.484375);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.371875, (double)0.478125, (double)0.96875, (double)0.771875, (double)0.615625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.15625, (double)0.125, (double)0.96875, (double)0.96875, (double)0.25), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.603125, (double)0.528125, (double)0.96875, (double)0.915625, (double)0.596875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.21875, (double)0.371875, (double)0.603125, (double)0.7875, (double)0.753125, (double)0.753125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.28125, (double)0.415625, (double)0.74375, (double)0.73125, (double)0.709375, (double)0.89375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.40625, (double)0.478125, (double)0.884375, (double)0.60625, (double)0.646875, (double)0.909375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0375, (double)0.471875, (double)0.603125, (double)0.9875, (double)0.671875, (double)0.771875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.3125, (double)0.003125, (double)0.309375, (double)0.7, (double)0.103125, (double)0.690625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.425, (double)0.103125, (double)0.553125, (double)0.56875, (double)0.259375, (double)0.884375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.125, (double)0.103125, (double)0.759375, (double)0.8875, (double)0.234375, (double)0.853125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.825, (double)0.228125, (double)0.759375, (double)0.8875, (double)0.359375, (double)0.853125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.825, (double)0.271875, (double)0.665625, (double)0.8875, (double)0.528125, (double)0.759375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.125, (double)0.271875, (double)0.665625, (double)0.1875, (double)0.528125, (double)0.759375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.125, (double)0.228125, (double)0.759375, (double)0.1875, (double)0.359375, (double)0.853125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }

    public static VoxelShape createHangingVoxelShape() {
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.03125, (double)0.3125, (double)0.140625, (double)0.96875, (double)0.5, (double)0.421875);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.328125, (double)0.421875, (double)0.96875, (double)0.953125, (double)0.609375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.40625, (double)0.578125, (double)0.859375, (double)0.59375, (double)0.828125, (double)0.921875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.28125, (double)0.9375, (double)0.296875, (double)0.71875, (double)1.0, (double)0.734375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.640625, (double)0.03125, (double)0.96875, (double)0.765625, (double)0.15625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.625, (double)0.390625, (double)0.96875, (double)0.875, (double)0.421875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.390625, (double)0.609375, (double)0.96875, (double)0.890625, (double)0.796875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.28125, (double)0.453125, (double)0.609375, (double)0.71875, (double)0.953125, (double)0.859375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.21875, (double)0.328125, (double)0.609375, (double)0.78125, (double)0.390625, (double)0.734375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.171875, (double)0.21875, (double)0.96875, (double)0.3125, (double)0.34375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.046875, (double)0.28125, (double)0.96875, (double)0.171875, (double)0.40625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.5, (double)0.078125, (double)0.96875, (double)0.640625, (double)0.203125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        boolean isHanging = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_222514_j);
        switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
            case EAST: {
                return isHanging ? HANGING_EAST : EAST;
            }
            case SOUTH: {
                return isHanging ? HANGING_SOUTH : SOUTH;
            }
            case WEST: {
                return isHanging ? HANGING_WEST : WEST;
            }
        }
        return isHanging ? HANGING_NORTH : NORTH;
    }
}

