/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks.monitor;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.tardis.mod.ars.IARS;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.GuiContext;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.monitors.MonitorTile;

public class MonitorBlock
extends NotSolidTileBlock
implements IWaterLoggable,
IARS {
    private double textX;
    private double textY;
    private double textZ;
    private double width;
    private double height;
    private int guiID = 1;

    public MonitorBlock(AbstractBlock.Properties prop, int guiID, double x, double y, double z, double width, double height) {
        super(prop);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_222514_j, (Comparable)Boolean.valueOf(false)));
        this.textX = x;
        this.textY = y;
        this.textZ = z;
        this.width = width;
        this.height = height;
        this.guiID = guiID;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        TileEntity te = super.createTileEntity(state, world);
        if (te instanceof MonitorTile) {
            ((MonitorTile)te).setGuiXYZ(this.textX, this.textY, this.textZ, this.width, this.height);
        }
        return te;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
        builder.func_206894_a(new Property[]{BlockStateProperties.field_222514_j});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195999_j().func_174811_aO().func_176734_d())).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluid.getFluidState().func_206884_a((ITag)FluidTags.field_206959_a)))).func_206870_a((Property)BlockStateProperties.field_222514_j, (Comparable)Boolean.valueOf(context.func_196000_l() == Direction.DOWN));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return state;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_225608_bj_()) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_184586_b(handIn).func_77973_b() == Items.field_151098_aY) {
            if (!worldIn.field_72995_K) {
                TardisHelper.getConsoleInWorld(worldIn).ifPresent(tile -> {
                    MapData data = FilledMapItem.func_195950_a((ItemStack)player.func_184586_b(handIn), (World)worldIn);
                    if (WorldHelper.canTravelToDimension((World)worldIn.func_73046_m().func_71218_a(data.field_76200_c))) {
                        BlockPos dest = new BlockPos(data.field_76201_a, tile.getDestinationPosition().func_177956_o(), data.field_76199_b);
                        tile.setDestination((RegistryKey<World>)data.field_76200_c, dest);
                        worldIn.func_184133_a(null, pos, (SoundEvent)TSounds.REMOTE_ACCEPT.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        PlayerHelper.sendMessageToPlayer(player, new TranslationTextComponent("message.tardis.set_coord_map", new Object[]{WorldHelper.formatBlockPos(dest)}), false);
                    } else {
                        PlayerHelper.sendMessageToPlayer(player, TardisConstants.Translations.CANT_USE_IN_DIM, true);
                        worldIn.func_184133_a(null, pos, SoundEvents.field_189106_R, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                });
            }
            return ActionResultType.SUCCESS;
        }
        if (!WorldHelper.isDimensionBlocked(worldIn)) {
            if (worldIn.field_72995_K) {
                ClientHelper.openGUI(this.guiID, new GuiContext());
            }
            return ActionResultType.SUCCESS;
        }
        if (!worldIn.func_201670_d()) {
            player.func_146105_b((ITextComponent)TardisConstants.Translations.NO_USE_OUTSIDE_TARDIS, true);
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }
}

