/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks.exteriors;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.enums.EnumMatterState;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDontBreak;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class ExteriorBlock
extends NotSolidTileBlock
implements IDontBreak {
    public static TranslationTextComponent LOCKED = new TranslationTextComponent("message.tardis.door.locked");
    public static TranslationTextComponent UNLOCKED = new TranslationTextComponent("message.tardis.door.unlocked");
    public static TranslationTextComponent DEADLOCKED = new TranslationTextComponent("message.tardis.door.deadlocked");
    public static String INTERIOR_CHANGE = "message.tardis.door.interior_change";
    public int rand;

    public ExteriorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_175972_I).func_200947_a(SoundType.field_185848_a).func_200948_a(-1.0f, 2.0f).func_208770_d().func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            ExteriorTile exterior;
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof ExteriorTile && (exterior = (ExteriorTile)te).getMatterState() == EnumMatterState.SOLID) {
                ItemStack held;
                ItemStack itemStack = held = player.func_184614_ca() != ItemStack.field_190927_a ? player.func_184614_ca() : player.func_184592_cb();
                if (held.func_77973_b() == Items.field_151057_cb) {
                    exterior.setCustomName(held.func_82837_s() ? held.func_200301_q().getString() : "");
                    if (!player.func_184812_l_()) {
                        player.func_184586_b(handIn).func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (exterior.isKeyValid(held)) {
                    if (!exterior.isExteriorDeadLocked() && !exterior.isInteriorRegenerating()) {
                        exterior.toggleLocked();
                        worldIn.func_184133_a(null, pos, exterior.getLocked() ? (SoundEvent)TSounds.DOOR_LOCK.get() : (SoundEvent)TSounds.DOOR_UNLOCK.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        player.func_146105_b((ITextComponent)(exterior.getLocked() ? LOCKED : UNLOCKED), true);
                    } else if (exterior.isInteriorRegenerating()) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(INTERIOR_CHANGE, new Object[]{exterior.getRemainingInteriorChangeTime()}), true);
                    } else if (exterior.isExteriorDeadLocked()) {
                        player.func_146105_b((ITextComponent)DEADLOCKED, true);
                    }
                } else {
                    exterior.open((Entity)player);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        ((ExteriorTile)worldIn.func_175625_s(hit.func_216350_a())).damage(4);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207188_f() : Fluids.field_204541_a.func_207188_f();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        ExteriorTile exterior;
        if (!worldIn.field_72995_K && (exterior = (ExteriorTile)worldIn.func_175625_s(pos)) != null && exterior.getLocked()) {
            TardisHelper.getConsole(worldIn.func_73046_m(), exterior.getInteriorDimensionKey()).ifPresent(console -> console.func_145831_w().func_184133_a(null, console.func_174877_v(), (SoundEvent)TSounds.DOOR_KNOCK.get(), SoundCategory.BLOCKS, 1.0f, 1.0f));
            worldIn.func_184133_a(null, pos, (SoundEvent)TSounds.DOOR_KNOCK.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            ((ExteriorTile)worldIn.func_175625_s(pos)).fall();
            worldIn.func_175713_t(pos);
            if (worldIn instanceof ServerWorld) {
                WorldHelper.unForceChunkIfLoaded((ServerWorld)worldIn, new ChunkPos(pos), pos);
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        if (worldIn instanceof ServerWorld) {
            WorldHelper.forceChunkIfNotLoaded((ServerWorld)worldIn, new ChunkPos(pos), pos);
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return true;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ExteriorTile) {
            return ((ExteriorTile)te).getLightEmittingLevel();
        }
        return super.getLightValue(state, world, pos);
    }
}

