/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.properties.Prop;

public class XionCrystalBlock
extends Block
implements IWaterLoggable {
    public static final IntegerProperty TYPE = IntegerProperty.func_177719_a((String)"type", (int)0, (int)5);
    private static final VoxelShape shapeOne = VoxelShapes.func_197873_a((double)0.15625, (double)0.0, (double)0.125, (double)0.84375, (double)0.125, (double)0.8125);
    private static final VoxelShape shapeTwo = XionCrystalBlock.getShapeTwo();
    private static final VoxelShape shapeThree = XionCrystalBlock.getShapeThree();
    private static final VoxelShape shapeFour = XionCrystalBlock.getShapeFour();
    private static final VoxelShape shapeFive = XionCrystalBlock.getShapeFive();
    private static final VoxelShape shapeSix = VoxelShapes.func_197873_a((double)0.09375, (double)0.0, (double)0.09375, (double)0.90625, (double)0.14375, (double)0.90625);

    public XionCrystalBlock() {
        super(Prop.Blocks.BASIC_CRYSTAL.get().func_226896_b_().func_208770_d().func_235838_a_(state -> 15).func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        int randomState = context.func_195991_k().field_73012_v.nextInt(5);
        boolean isWaterLogged = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)TYPE, (Comparable)Integer.valueOf(randomState))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(isWaterLogged));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Integer)state.func_177229_b((Property)TYPE)) {
            case 0: {
                return shapeOne;
            }
            case 1: {
                return shapeTwo;
            }
            case 2: {
                return shapeThree;
            }
            case 3: {
                return shapeFour;
            }
            case 4: {
                return shapeFive;
            }
            case 5: {
                return shapeSix;
            }
        }
        return shapeOne;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
        if (state.func_177230_c() != newState.func_177230_c() && newState.func_177230_c() == TBlocks.xion_crystal.get()) {
            worldIn.func_175656_a(pos, XionCrystalBlock.getRandomCrystalState(worldIn.func_201674_k()));
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return !worldIn.func_201670_d() && !worldIn.func_180495_p(pos.func_177977_b()).func_196958_f();
    }

    public static BlockState getRandomCrystalState(Random rand) {
        return (BlockState)((XionCrystalBlock)TBlocks.xion_crystal.get()).func_176223_P().func_206870_a((Property)TYPE, (Comparable)Integer.valueOf(rand.nextInt(TYPE.func_177700_c().size())));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!worldIn.field_72995_K && worldIn.func_175623_d(pos.func_177977_b())) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public static void grow(World world, BlockPos pos) {
        ArrayList viablePoses = Lists.newArrayList();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos cPos = pos.func_177982_a(x, y, z);
                    if (!world.func_175623_d(cPos) || !world.func_180495_p(cPos.func_177977_b()).func_200132_m()) continue;
                    viablePoses.add(cPos);
                }
            }
        }
        if (!viablePoses.isEmpty()) {
            world.func_175656_a((BlockPos)viablePoses.get(world.field_73012_v.nextInt(viablePoses.size())), XionCrystalBlock.getRandomCrystalState(world.func_201674_k()));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new Property[]{TYPE, BlockStateProperties.field_208198_y}));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    private static VoxelShape getShapeTwo() {
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.396446875, (double)0.4375, (double)0.5625, (double)0.646446875);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.4375, (double)0.0, (double)0.208946875, (double)0.625, (double)0.125, (double)0.396446875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.4375, (double)0.0, (double)0.521446875, (double)0.6875, (double)0.125, (double)0.771446875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }

    private static VoxelShape getShapeThree() {
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.375, (double)0.0, (double)0.333946875, (double)0.6875, (double)0.125, (double)0.646446875);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.396446875, (double)0.375, (double)0.375, (double)0.521446875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.6875, (double)0.0, (double)0.583946875, (double)0.875, (double)0.25, (double)0.708946875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.375, (double)0.0, (double)0.208946875, (double)0.625, (double)0.3125, (double)0.333946875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }

    private static VoxelShape getShapeFour() {
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.396446875, (double)0.4375, (double)0.4375, (double)0.521446875);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.625, (double)0.0, (double)0.583946875, (double)0.875, (double)0.4375, (double)0.708946875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.375, (double)0.0, (double)0.208946875, (double)0.625, (double)0.4375, (double)0.333946875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.4375, (double)0.0, (double)0.3125, (double)0.6875, (double)0.0625, (double)0.625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }

    private static VoxelShape getShapeFive() {
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.4375, (double)0.0, (double)0.5, (double)0.75, (double)0.125, (double)0.8125);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.333946875, (double)0.5, (double)0.4375, (double)0.583946875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.15625, (double)0.0, (double)0.208946875, (double)0.40625, (double)0.1875, (double)0.458946875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.521446875, (double)0.3125, (double)0.125, (double)0.646446875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.4375, (double)0.0, (double)0.271446875, (double)0.625, (double)0.25, (double)0.396446875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }
}

