/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tardis.mod.blocks.TileBlock;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.sounds.TSounds;

public class TransductionBarrierBlock
extends TileBlock {
    public static final BooleanProperty ACTIVATED = BooleanProperty.func_177716_a((String)"activated");
    private final IFormattableTextComponent descriptionTooltip = TextHelper.createDescriptionItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tardis.transduction_barrier.line1"));
    private final IFormattableTextComponent descriptionTooltipTwo = TextHelper.createExtraLineItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tardis.transduction_barrier.line2"));
    private final IFormattableTextComponent descriptionTooltipThree = TextHelper.createExtraLineItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tardis.transduction_barrier.line3"));

    public TransductionBarrierBlock(AbstractBlock.Properties prop) {
        super(prop);
        this.setShowTooltips(true);
        this.setHasDescriptionTooltips(true);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack sonic = new ItemStack((IItemProvider)TItems.SONIC.get());
        if (player.func_184586_b(handIn).func_77969_a(sonic)) {
            return ActionResultType.SUCCESS;
        }
        PlayerHelper.sendMessageToPlayer(player, TardisConstants.Translations.REQUIRES_SONIC, true);
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ACTIVATED});
        super.func_206840_a(builder);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        if (!world.field_72995_K && (powered = world.func_175640_z(pos)) != (Boolean)state.func_177229_b((Property)ACTIVATED)) {
            BlockState newState = (BlockState)state.func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(powered));
            world.func_184133_a(null, pos, powered ? (SoundEvent)TSounds.SUBSYSTEMS_ON.get() : (SoundEvent)TSounds.SUBSYSTEMS_OFF.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
            world.func_180501_a(pos, newState, 2);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void createDescriptionTooltips(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.descriptionTooltip);
        tooltip.add((ITextComponent)this.descriptionTooltipTwo);
        tooltip.add((ITextComponent)this.descriptionTooltipThree);
    }
}

