/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tardis.mod.ars.IARS;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.containers.EngineContainer;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.EngineSliderSyncMessage;
import net.tardis.mod.properties.Prop;
import net.tardis.mod.tileentities.TardisEngineTile;
import net.tardis.mod.tileentities.inventory.PanelInventory;

public class TardisEngineBlock
extends NotSolidTileBlock
implements IARS {
    public TardisEngineBlock() {
        super(Prop.Blocks.BASIC_TECH.get());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TardisEngineTile && !worldIn.field_72995_K) {
            ServerWorld sWorld = (ServerWorld)worldIn;
            LazyOptional data = worldIn.getCapability(Capabilities.TARDIS_DATA);
            data.ifPresent(cap -> {
                final Direction dir = hit.func_216354_b() != Direction.UP && hit.func_216354_b() != Direction.DOWN ? hit.func_216354_b() : player.func_174811_aO().func_176734_d();
                final PanelInventory inv = cap.getEngineInventoryForSide(dir);
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity ent) {
                        return new EngineContainer(id, playerInv, inv, dir);
                    }

                    public ITextComponent func_145748_c_() {
                        return inv.getName();
                    }
                }, buf -> buf.writeInt(dir.func_176745_a()));
                if (dir == Direction.SOUTH && player instanceof ServerPlayerEntity) {
                    ServerPlayerEntity sPlayer = (ServerPlayerEntity)player;
                    sWorld.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> Network.sendTo(EngineSliderSyncMessage.create(10, sWorld), sPlayer)));
                }
            });
            if (!data.isPresent() && !worldIn.field_72995_K) {
                player.func_146105_b((ITextComponent)TardisConstants.Translations.NO_USE_OUTSIDE_TARDIS, true);
            }
        }
        return ActionResultType.SUCCESS;
    }
}

