/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tardis.mod.blocks.misc.VoxelShapeDirectional;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.helper.VoxelShapeUtils;

public class SteamGrateBlock
extends Block {
    public static final VoxelShapeDirectional SHAPE = new VoxelShapeDirectional(SteamGrateBlock.createShape());

    public SteamGrateBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208149_B, (Comparable)Boolean.valueOf(false)));
    }

    public static VoxelShape createShape() {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0);
    }

    public static VoxelShape createShapeUp() {
        return Block.func_208617_a((double)0.0, (double)16.0, (double)3.0, (double)16.0, (double)15.0, (double)13.0);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int ticksBeforeAction;
        super.func_180655_c(stateIn, worldIn, pos, rand);
        boolean isUp = (Boolean)stateIn.func_177229_b((Property)BlockStateProperties.field_208149_B);
        int randomTickSpeed = worldIn.func_82736_K().func_223592_c(GameRules.field_223610_m);
        int n = ticksBeforeAction = randomTickSpeed > 3 && randomTickSpeed < 300 ? 300 - randomTickSpeed : 300;
        if (worldIn.func_82737_E() % (long)ticksBeforeAction == 0L) {
            for (int i = 0; i < 300; ++i) {
                double horSpeed = (double)i / 300.0 * 0.2;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197613_f, (double)pos.func_177958_n() + 0.3, (double)pos.func_177956_o() + (isUp ? 0.5 : 0.1) + (double)i / 300.0 * 2.0, (double)pos.func_177952_p() + 0.5, rand.nextDouble() * horSpeed - horSpeed / 2.0, 0.05, rand.nextDouble() * horSpeed - horSpeed / 2.0);
            }
            ClientHelper.playSteamSoundOnClient(worldIn, pos);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_235901_b_((Property)BlockStateProperties.field_208157_J) ? (state.func_235901_b_((Property)BlockStateProperties.field_208149_B) ? (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208149_B)).booleanValue() ? VoxelShapeUtils.rotateHorizontal(SteamGrateBlock.createShapeUp(), (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)) : SHAPE.getFor((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J))) : SHAPE.getFor((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J))) : SHAPE.getFor(Direction.NORTH);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        Direction horizontalFacing = context.func_195999_j().func_174811_aO();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)horizontalFacing.func_176734_d())).func_206870_a((Property)BlockStateProperties.field_208149_B, (Comparable)Boolean.valueOf(direction.func_176734_d() != Direction.DOWN));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J, BlockStateProperties.field_208198_y, BlockStateProperties.field_208149_B});
    }
}

