/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.tardis.mod.blocks.ICrewTask;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.containers.ShipComputerContainer;
import net.tardis.mod.helper.TInventoryHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.properties.Prop;
import net.tardis.mod.tileentities.ShipComputerTile;

public class ShipComputerBlock
extends NotSolidTileBlock
implements ICrewTask {
    public ShipComputerBlock() {
        super(Prop.Blocks.BASIC_TECH.get());
    }

    public ActionResultType func_225533_a_(BlockState state, final World worldIn, final BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof ShipComputerTile) {
            ShipComputerTile comp = (ShipComputerTile)te;
            ItemStack held = player.func_184586_b(handIn);
            if (comp.getLootTable() != null) {
                comp.fillWithLoot(player);
            }
            if (comp.getSchematic() != null && held.func_77973_b() == TItems.SONIC.get()) {
                held.getCapability(Capabilities.SONIC_CAPABILITY).ifPresent(cap -> {
                    cap.getSchematics().add(comp.getSchematic());
                    comp.setSchematic(null);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.computer.downloaded"), true);
                });
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int id, PlayerInventory inv, PlayerEntity p_createMenu_3_) {
                        return new ShipComputerContainer(id, inv, (ShipComputerTile)worldIn.func_175625_s(pos));
                    }

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent("container.tardis.ship_computer");
                    }
                }, buf -> buf.func_179255_a(pos));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195999_j().func_174811_aO().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.func_201670_d() && state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te != null) {
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(cap -> TInventoryHelper.dropInventoryItems(worldIn, pos, cap));
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    @Override
    public void setUsing(boolean used, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShipComputerTile) {
            ShipComputerTile comp = (ShipComputerTile)te;
            comp.setIsBeingUsed(used);
        }
    }

    @Override
    public boolean isBeingUsed(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShipComputerTile) {
            return ((ShipComputerTile)te).isBeingUsed();
        }
        return false;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.BLOCKED;
    }
}

