/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.VoxelShapeUtils;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.properties.Prop;

public class RoundelTapBlock
extends NotSolidTileBlock {
    public static final BooleanProperty PUSH = BooleanProperty.func_177716_a((String)"push");
    public static final TranslationTextComponent PUSH_TO_TARDIS = new TranslationTextComponent("message.tardis.roundel_tap.push_to_tardis");
    public static final TranslationTextComponent PULL_TO_BLOCKS_FROM_TARDIS = new TranslationTextComponent("message.tardis.roundel_tap.push_to_blocks");
    public static final VoxelShape NORTH = VoxelShapeUtils.rotate(RoundelTapBlock.createVoxelShape(), Direction.SOUTH);
    public static final VoxelShape EAST = VoxelShapeUtils.rotate(RoundelTapBlock.createVoxelShape(), Direction.WEST);
    public static final VoxelShape SOUTH = VoxelShapeUtils.rotate(RoundelTapBlock.createVoxelShape(), Direction.NORTH);
    public static final VoxelShape WEST = VoxelShapeUtils.rotate(RoundelTapBlock.createVoxelShape(), Direction.EAST);
    public static final VoxelShape UP = RoundelTapBlock.createVoxelShape();
    public static final VoxelShape DOWN = VoxelShapeUtils.rotate(RoundelTapBlock.createVoxelShape(), Direction.UP);
    private final IFormattableTextComponent descriptionTooltip = TextHelper.createDescriptionItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.roundel_tap.purpose"));
    private final IFormattableTextComponent descriptionTooltipTwo = TextHelper.createExtraLineItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.roundel_tap.use"));

    public RoundelTapBlock() {
        super(Prop.Blocks.BASIC_TECH.get());
    }

    public static VoxelShape createVoxelShape() {
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.125, (double)0.046875, (double)0.125, (double)0.875, (double)0.796875, (double)0.875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.1875, (double)0.78125, (double)0.1875, (double)0.8125, (double)0.84375, (double)0.8125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.25, (double)0.0625, (double)0.25, (double)0.75, (double)0.8125, (double)0.75), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.375, (double)0.8125, (double)0.375, (double)0.625, (double)1.0, (double)0.625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.375, (double)0.375, (double)0.125, (double)0.625, (double)0.625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.375, (double)0.375, (double)0.875, (double)0.625, (double)0.625, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.875, (double)0.375, (double)0.375, (double)1.0, (double)0.625, (double)0.625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.375, (double)0.375, (double)0.0, (double)0.625, (double)0.625, (double)0.125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)) {
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        return RoundelTapBlock.createVoxelShape();
    }

    public void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H}).func_206894_a(new Property[]{PUSH});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)context.func_196010_d().func_176734_d());
    }

    @Override
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_CONTROL);
        if (Screen.func_231172_r_()) {
            tooltip.clear();
            tooltip.add(0, stack.func_200301_q());
            tooltip.add((ITextComponent)TardisConstants.Translations.NO_USE_OUTSIDE_TARDIS);
            tooltip.add((ITextComponent)this.descriptionTooltip);
            tooltip.add((ITextComponent)this.descriptionTooltipTwo);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity && WorldHelper.isDimensionBlocked(worldIn)) {
            PlayerHelper.sendMessageToPlayer((PlayerEntity)placer, TardisConstants.Translations.NO_USE_OUTSIDE_TARDIS, true);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.func_201670_d()) {
            BlockState newState = WorldHelper.cycleBlockStateProperty(state, PUSH);
            world.func_180501_a(pos, newState, 3);
            boolean isPushingToTardis = (Boolean)newState.func_177229_b((Property)PUSH);
            player.func_146105_b((ITextComponent)(!isPushingToTardis ? PUSH_TO_TARDIS : PULL_TO_BLOCKS_FROM_TARDIS), true);
        }
        return ActionResultType.SUCCESS;
    }
}

