/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.tardis.mod.blocks.misc.VoxelShapeDirectional;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.containers.SpectrometerContainer;
import net.tardis.mod.helper.TInventoryHelper;
import net.tardis.mod.properties.Prop;
import net.tardis.mod.tileentities.machines.NeutronicSpectrometerTile;

public class NeutronicSpectrometerBlock
extends NotSolidTileBlock
implements IWaterLoggable {
    public static final VoxelShapeDirectional SHAPE = new VoxelShapeDirectional(NeutronicSpectrometerBlock.makeShape());

    public NeutronicSpectrometerBlock() {
        super(Prop.Blocks.BASIC_TECH.get());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE.getFor((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J, BlockStateProperties.field_208198_y});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        final TileEntity te = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && te instanceof NeutronicSpectrometerTile) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity ent) {
                    return new SpectrometerContainer(id, playerInv, (NeutronicSpectrometerTile)te);
                }

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("container.tardis.spectrometer");
                }
            }, buf -> buf.func_179255_a(pos));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.func_201670_d() && state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te != null) {
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(cap -> TInventoryHelper.dropInventoryItems(worldIn, pos, cap));
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = VoxelShapes.func_197880_a();
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.5625, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.0625, (double)0.875, (double)0.9375, (double)0.5625, (double)0.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.875, (double)0.0625, (double)0.375, (double)0.9375, (double)0.5625, (double)0.875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.0625, (double)0.375, (double)0.125, (double)0.5625, (double)0.875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }
}

