/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.tardis.mod.Tardis;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.tileentities.IMultiblock;
import net.tardis.mod.tileentities.MultiblockMasterTile;
import org.apache.logging.log4j.Level;

public class MultiblockBlock
extends NotSolidTileBlock {
    public MultiblockBlock(AbstractBlock.Properties prop) {
        super(prop);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        if (state != this.getMasterState(worldIn, pos)) {
            return this.getMasterState(worldIn, pos).func_185903_a(player, worldIn, pos);
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.getMasterState((IBlockReader)worldIn, pos) != state) {
            if (this.getMasterState((IBlockReader)worldIn, pos).hasTileEntity()) {
                if (worldIn.func_175625_s(pos) instanceof IMultiblock) {
                    IMultiblock multiblock = (IMultiblock)worldIn.func_175625_s(pos);
                    BlockPos masterPos = multiblock.getMaster();
                    BlockRayTraceResult masterResultHit = new BlockRayTraceResult(hit.func_216347_e(), hit.func_216354_b(), masterPos, false);
                    return this.getMasterState((IBlockReader)worldIn, pos).func_227031_a_(worldIn, player, handIn, masterResultHit);
                }
            } else {
                return this.getMasterState((IBlockReader)worldIn, pos).func_227031_a_(worldIn, player, handIn, hit);
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean func_181623_g() {
        return false;
    }

    public float getSlipperiness(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        return this.getMasterState((IBlockReader)world, pos) == state ? super.getSlipperiness(state, world, pos, entity) : this.getMasterState((IBlockReader)world, pos).getSlipperiness(world, pos, entity);
    }

    public BlockState getMasterState(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IMultiblock) {
            return ((IMultiblock)te).getMasterState();
        }
        return world.func_180495_p(pos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockState masterState;
        super.func_176208_a(worldIn, pos, state, player);
        if (!worldIn.func_201670_d() && !player.field_71075_bZ.field_75098_d && state != (masterState = this.getMasterState((IBlockReader)worldIn, pos))) {
            Block.func_220075_c((BlockState)masterState, (World)worldIn, (BlockPos)pos);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        BlockState masterState = this.getMasterState(world, pos);
        ItemStack masterBlockStack = new ItemStack((IItemProvider)masterState.func_177230_c().func_199767_j());
        return masterBlockStack;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        try {
            if (newState.func_177230_c() != state.func_177230_c()) {
                if (worldIn.func_175625_s(pos) instanceof MultiblockMasterTile) {
                    for (BlockPos other : ((MultiblockMasterTile)worldIn.func_175625_s(pos)).getSlavePositions()) {
                        worldIn.func_175656_a(other, Blocks.field_150350_a.func_176223_P());
                    }
                } else {
                    worldIn.func_175656_a(((IMultiblock)worldIn.func_175625_s(pos)).getMaster(), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        catch (ClassCastException e) {
            Tardis.LOGGER.catching(Level.DEBUG, (Throwable)e);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluid.getFluidState().func_206884_a((ITag)FluidTags.field_206959_a)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = stateIn;
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return state;
    }
}

