/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.IDontBreak;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.world.dimensions.TDimensions;

public class ConsoleBlock
extends NotSolidTileBlock
implements IDontBreak {
    public ConsoleBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_175972_I).func_208770_d().func_200948_a(99999.0f, 99999.0f));
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        if (!WorldHelper.areDimensionTypesSame(world, TDimensions.DimensionTypes.TARDIS_TYPE)) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            return;
        }
        if (!world.field_72995_K) {
            ServerWorld sWorld = world.func_73046_m().func_71218_a(world.func_234923_W_());
            ChunkPos chunkPos = new ChunkPos(pos);
            WorldHelper.forceChunkIfNotLoaded(sWorld, chunkPos, pos);
        }
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.type.func_200968_a();
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (state.hasTileEntity() && (state.func_177230_c() != newState.func_177230_c() || !newState.hasTileEntity())) {
            worldIn.func_175713_t(pos);
            if (worldIn instanceof ServerWorld) {
                WorldHelper.unForceChunkIfLoaded((ServerWorld)worldIn, new ChunkPos(pos), pos);
            }
        }
        if (!WorldHelper.areDimensionTypesSame(worldIn, TDimensions.DimensionTypes.TARDIS_TYPE)) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            return;
        }
        if (!worldIn.field_72995_K) {
            TileEntity te;
            if (newState.func_177230_c() != state.func_177230_c() && (te = worldIn.func_175625_s(pos)) instanceof ConsoleTile) {
                ((ConsoleTile)te).removeControls();
            }
            if (newState.func_177230_c() instanceof ConsoleBlock && (te = worldIn.func_175625_s(pos)) instanceof ConsoleTile) {
                ((ConsoleTile)te).getOrCreateControls();
            }
        }
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.BLOCKED;
    }
}

