/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tardis.mod.ars.IARS;
import net.tardis.mod.entity.ChairEntity;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.helper.VoxelShapeUtils;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.properties.Prop;

public class ChairBlock
extends Block
implements IARS {
    public static final VoxelShape NORTH = ChairBlock.createVoxelShape();
    public static final VoxelShape EAST = VoxelShapeUtils.rotate(ChairBlock.createVoxelShape(), Rotation.CLOCKWISE_90);
    public static final VoxelShape SOUTH = VoxelShapeUtils.rotate(ChairBlock.createVoxelShape(), Rotation.CLOCKWISE_180);
    public static final VoxelShape WEST = VoxelShapeUtils.rotate(ChairBlock.createVoxelShape(), Rotation.COUNTERCLOCKWISE_90);
    private float yOffset = 0.25f;

    public ChairBlock(float yOffset) {
        super(Prop.Blocks.BASIC_WOOD.get().func_226896_b_());
        this.yOffset = yOffset;
    }

    public boolean sit(World world, BlockPos pos, Entity sitter) {
        if (!world.field_72995_K && !ChairBlock.isOccupied(world, pos)) {
            ChairEntity chair = (ChairEntity)((EntityType)TEntities.CHAIR.get()).func_200721_a(world);
            chair.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            chair.setYOffset(this.yOffset);
            chair.field_70177_z = WorldHelper.getAngleFromFacing(WorldHelper.getFacingForState(world.func_180495_p(pos)));
            world.func_217376_c((Entity)chair);
            sitter.func_184220_m((Entity)chair);
            return true;
        }
        return false;
    }

    public static boolean isOccupied(World world, BlockPos pos) {
        return !world.func_217357_a(ChairEntity.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos)).isEmpty();
    }

    public static VoxelShape createVoxelShape() {
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.0703125, (double)0.5, (double)0.875, (double)0.9375, (double)1.5, (double)1.0);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.8703125, (double)0.59375, (double)0.0625, (double)1.0015625, (double)0.71875, (double)0.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)-0.0046875, (double)0.59375, (double)0.0625, (double)0.1265625, (double)0.71875, (double)0.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.8703125, (double)0.375, (double)0.0625, (double)0.9859375, (double)0.59375, (double)0.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0109375, (double)0.375, (double)0.0625, (double)0.1265625, (double)0.59375, (double)0.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.8703125, (double)0.71875, (double)0.71875, (double)1.0015625, (double)1.296875, (double)0.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)-0.0046875, (double)0.71875, (double)0.71875, (double)0.1265625, (double)1.296875, (double)0.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0703125, (double)0.375, (double)0.0, (double)0.9375, (double)0.5, (double)1.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.3125, (double)0.0625, (double)0.9375, (double)0.40625, (double)0.9375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.015625, (double)0.015625, (double)0.015625, (double)0.109375, (double)0.109375, (double)0.109375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.015625, (double)0.28125, (double)0.015625, (double)0.109375, (double)0.375, (double)0.109375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.0, (double)0.03125, (double)0.09375, (double)0.625, (double)0.09375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.015625, (double)0.609375, (double)0.015625, (double)0.109375, (double)0.703125, (double)0.0625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.890625, (double)0.015625, (double)0.015625, (double)0.984375, (double)0.109375, (double)0.109375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.890625, (double)0.28125, (double)0.015625, (double)0.984375, (double)0.375, (double)0.109375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.890625, (double)0.609375, (double)0.015625, (double)0.984375, (double)0.703125, (double)0.0625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.0, (double)0.03125, (double)0.96875, (double)0.625, (double)0.09375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.890625, (double)0.609375, (double)0.9375, (double)0.984375, (double)0.703125, (double)0.984375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.890625, (double)0.015625, (double)0.890625, (double)0.984375, (double)0.109375, (double)0.984375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.890625, (double)0.28125, (double)0.890625, (double)0.984375, (double)0.375, (double)0.984375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.0, (double)0.90625, (double)0.96875, (double)0.625, (double)0.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.015625, (double)0.609375, (double)0.9375, (double)0.109375, (double)0.703125, (double)0.984375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.015625, (double)0.015625, (double)0.890625, (double)0.109375, (double)0.109375, (double)0.984375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.015625, (double)0.28125, (double)0.890625, (double)0.109375, (double)0.375, (double)0.984375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.0, (double)0.90625, (double)0.09375, (double)0.625, (double)0.96875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195999_j().func_174811_aO().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            this.sit(worldIn, pos, (Entity)player);
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.BLOCKED;
    }
}

