/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.LeadItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.misc.IDontBreak;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.BrokenExteriorTile;
import net.tardis.mod.world.dimensions.TDimensions;

public class BrokenExteriorBlock
extends NotSolidTileBlock
implements IDontBreak {
    public BlockItem ITEM = new BlockItemBrokenExterior(this);

    public BrokenExteriorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_175972_I).func_200943_b(9999.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        ItemStack stack = player.func_184586_b(handIn);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BrokenExteriorTile) {
            if (stack.func_190926_b() && LeadItem.func_226641_a_((PlayerEntity)player, (World)worldIn, (BlockPos)pos) == ActionResultType.SUCCESS) {
                ((BrokenExteriorTile)te).startForceTame(player);
            }
            if (((BrokenExteriorTile)te).onPlayerRightClick(player, stack) && !player.func_184812_l_()) {
                player.func_184586_b(handIn).func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextDouble() < 0.05) {
            for (int i = 0; i < 18; ++i) {
                double angle = Math.toRadians(i * 20);
                double x = Math.sin(angle);
                double z = Math.cos(angle);
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)TSounds.ELECTRIC_SPARK.get(), SoundCategory.BLOCKS, 0.05f, 1.0f, false);
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)pos.func_177958_n() + 0.5 + x, (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + 0.5 + z, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195999_j() != null) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195999_j().func_174811_aO().func_176734_d());
        }
        return this.func_176223_P();
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return false;
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        return false;
    }

    @Override
    public boolean addHitEffects(BlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return false;
    }

    @Override
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public static class BlockItemBrokenExterior
    extends BlockItem {
        public BlockItemBrokenExterior(Block blockIn) {
            super(blockIn, new Item.Properties().func_200916_a(TItemGroups.MAIN));
        }

        protected boolean func_195944_a(BlockItemUseContext cont, BlockState state) {
            return cont.func_196000_l() == Direction.UP && cont.func_195991_k().func_180495_p(cont.func_195995_a().func_177984_a()).func_196953_a(cont) && !WorldHelper.areDimensionTypesSame(cont.func_195991_k(), TDimensions.DimensionTypes.TARDIS_TYPE);
        }

        protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
            return context.func_195991_k().func_175656_a(context.func_195995_a().func_177984_a(), state);
        }
    }
}

