/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.properties.Prop;
import net.tardis.mod.subsystem.AntennaSubsystem;
import net.tardis.mod.tileentities.console.misc.DistressSignal;
import net.tardis.mod.world.dimensions.TDimensions;

public class BeaconBlock
extends Block {
    public BeaconBlock() {
        super(Prop.Blocks.BASIC_TECH.get().func_226896_b_());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K && handIn == player.func_184600_cs()) {
            if (WorldHelper.canTravelToDimension(player.field_70170_p)) {
                player.func_184102_h().func_212370_w().forEach(serverWorld -> {
                    if (WorldHelper.areDimensionTypesSame((World)serverWorld, TDimensions.DimensionTypes.TARDIS_TYPE)) {
                        TardisHelper.getConsoleInWorld((World)serverWorld).ifPresent(tile -> tile.getSubsystem(AntennaSubsystem.class).ifPresent(ant -> {
                            if (ant.canBeUsed()) {
                                tile.addDistressSignal(new DistressSignal(new TranslationTextComponent("message.tardis.distress_signal.player", new Object[]{player.func_145748_c_().getString()}).getString(), new SpaceTimeCoord((RegistryKey<World>)player.field_70170_p.func_234923_W_(), pos)));
                            }
                        }));
                    }
                });
                PlayerHelper.sendMessageToPlayer(player, new TranslationTextComponent("message.tardis.beacon_sent"), true);
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                worldIn.func_184133_a(null, pos, SoundEvents.field_187631_bo, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                player.func_146105_b((ITextComponent)TardisConstants.Translations.CANT_USE_IN_DIM, true);
            }
        }
        if (worldIn.field_72995_K) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            for (int y = 0; y < 120; ++y) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197613_f, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + (double)y / 2.0, (double)pos.func_177952_p() + 0.5, 0.0, 0.05, 0.0);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)6.02, (double)0.0, (double)6.02, (double)9.98, (double)3.96, (double)9.98);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195999_j().func_174811_aO().func_176734_d())).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluid.getFluidState().func_206884_a((ITag)FluidTags.field_206959_a)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = stateIn;
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return state;
    }
}

