/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.helper.TInventoryHelper;
import net.tardis.mod.properties.Prop;
import net.tardis.mod.tileentities.machines.ArtronCollectorTile;

public class ArtronCollectorBlock
extends NotSolidTileBlock {
    public ArtronCollectorBlock() {
        super(Prop.Blocks.BASIC_TECH.get());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (handIn == Hand.OFF_HAND) {
            return ActionResultType.FAIL;
        }
        ArtronCollectorTile tile = (ArtronCollectorTile)worldIn.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(handIn);
        if (!tile.getItem().func_190926_b()) {
            this.dropCurrentItem(tile, player);
        }
        if (!stack.func_190926_b()) {
            tile.placeItem(stack.func_77946_l());
            player.func_184611_a(handIn, ItemStack.field_190927_a);
            tile.update();
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.func_201670_d() && state.func_177230_c() != newState.func_177230_c()) {
            ArtronCollectorTile collect = (ArtronCollectorTile)worldIn.func_175625_s(pos);
            if (!collect.getItem().func_190926_b()) {
                InventoryHelper.func_180173_a((World)worldIn, (double)((double)pos.func_177958_n() + 0.5), (double)(pos.func_177956_o() + 1), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)collect.getItem());
            }
            worldIn.func_175726_f(pos).getCapability(Capabilities.RIFT).ifPresent(cap -> {
                if (cap.isRift()) {
                    cap.addEnergy(collect.getArtron());
                }
            });
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public boolean dropCurrentItem(ArtronCollectorTile tile, PlayerEntity player) {
        if (!tile.getItem().func_190926_b()) {
            TInventoryHelper.giveStackTo((Entity)player, tile.getItem());
            tile.placeItem(ItemStack.field_190927_a);
            tile.update();
            return true;
        }
        return false;
    }
}

