/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.tardis.mod.blocks.template.NotSolidTileBlock;
import net.tardis.mod.containers.AlembicContainer;
import net.tardis.mod.helper.TInventoryHelper;
import net.tardis.mod.helper.VoxelShapeUtils;
import net.tardis.mod.properties.Prop;
import net.tardis.mod.tileentities.machines.AlembicTile;

public class AlembicBlock
extends NotSolidTileBlock {
    public static final VoxelShape NORTH = AlembicBlock.createVoxelShape();
    public static final VoxelShape EAST = VoxelShapeUtils.rotate(AlembicBlock.createVoxelShape(), Rotation.CLOCKWISE_90);
    public static final VoxelShape SOUTH = VoxelShapeUtils.rotate(AlembicBlock.createVoxelShape(), Rotation.CLOCKWISE_180);
    public static final VoxelShape WEST = VoxelShapeUtils.rotate(AlembicBlock.createVoxelShape(), Rotation.COUNTERCLOCKWISE_90);

    public AlembicBlock() {
        super(Prop.Blocks.BASIC_TECH.get());
        this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(false));
    }

    public static VoxelShape createVoxelShape() {
        VoxelShape shape = VoxelShapes.func_197873_a((double)0.578125, (double)0.515625, (double)0.3375, (double)0.890625, (double)0.578125, (double)0.65);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.0, (double)0.28125, (double)0.96875, (double)0.25, (double)0.34375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.90625, (double)0.0, (double)0.65625, (double)0.96875, (double)0.25, (double)0.71875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.0, (double)0.65625, (double)0.09375, (double)0.25, (double)0.71875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.0, (double)0.28125, (double)0.09375, (double)0.25, (double)0.34375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0, (double)0.203125, (double)0.25, (double)1.0, (double)0.265625, (double)0.75), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.46875, (double)0.1, (double)0.28125, (double)0.53125, (double)0.1625, (double)0.34375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.0625, (double)0.3125, (double)0.9375, (double)0.25, (double)0.6875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.671875, (double)0.75, (double)0.43125, (double)0.796875, (double)0.8125, (double)0.55625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.546875, (double)0.265625, (double)0.3125, (double)0.921875, (double)0.453125, (double)0.6875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.921875, (double)0.34375, (double)0.484375, (double)0.953125, (double)0.375, (double)0.515625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.953125, (double)0.328125, (double)0.46875, (double)0.984375, (double)0.390625, (double)0.53125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.609375, (double)0.421875, (double)0.36875, (double)0.859375, (double)0.484375, (double)0.61875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.578125, (double)0.484375, (double)0.3375, (double)0.890625, (double)0.546875, (double)0.65), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.578125, (double)0.721875, (double)0.3375, (double)0.890625, (double)0.784375, (double)0.65), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.640625, (double)0.796875, (double)0.4, (double)0.828125, (double)0.984375, (double)0.5875), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.546875, (double)0.5, (double)0.30625, (double)0.921875, (double)0.75, (double)0.68125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.03125, (double)0.265625, (double)0.453125, (double)0.09375, (double)0.578125, (double)0.515625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.34375, (double)0.265625, (double)0.453125, (double)0.40625, (double)0.578125, (double)0.515625), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.09375, (double)0.375, (double)0.359375, (double)0.34375, (double)0.625, (double)0.609375), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197873_a((double)0.125, (double)0.34375, (double)0.390625, (double)0.3125, (double)0.40625, (double)0.578125), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        return (BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208180_g});
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof AlembicTile && state.func_177230_c() != newState.func_177230_c()) {
            TInventoryHelper.dropInventoryItems(worldIn, pos, (IItemHandler)((AlembicTile)tileEntity).getItemStackHandler());
            worldIn.func_175713_t(pos);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)BlockStateProperties.field_208180_g)).booleanValue()) {
            Direction facing = (Direction)stateIn.func_177229_b((Property)BlockStateProperties.field_208157_J);
            double d1 = rand.nextDouble() * 0.2;
            double x = (double)pos.func_177958_n() + 0.4;
            double y = (double)pos.func_177956_o() + 1.0 + (double)rand.nextFloat() * 0.3;
            double z = (double)pos.func_177952_p() + 0.4;
            switch (facing) {
                case NORTH: {
                    x += d1 + 0.2;
                    z += 0.1;
                    break;
                }
                case EAST: {
                    x += 0.1;
                    z += d1 + 0.2;
                    break;
                }
                case SOUTH: {
                    x -= d1 + 0.2;
                    z += 0.2;
                }
                case WEST: {
                    x += 0.1;
                    z -= d1;
                    break;
                }
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public ActionResultType func_225533_a_(BlockState state, final World worldIn, final BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int id, PlayerInventory inv, PlayerEntity p_createMenu_3_) {
                    return new AlembicContainer(id, inv, (AlembicTile)worldIn.func_175625_s(pos));
                }

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("container.tardis.alembic");
                }
            }, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }
}

