/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.ars;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.Tardis;
import net.tardis.mod.ars.ARSHelper;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.misc.ConsoleRoomCodecListener;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.ReclamationTile;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ConsoleRoom {
    private static final Codec<ConsoleRoom> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("structure_resource_location").forGetter(ConsoleRoom::getStructureFilePath), (App)Codec.STRING.fieldOf("display_name").forGetter(name -> name.getDisplayName().getString()), (App)ResourceLocation.field_240908_a_.orElse((Object)new ResourceLocation("tardis", "textures/gui/interiors/generic_preview.png")).fieldOf("image_resource_location").forGetter(ConsoleRoom::getTexture), (App)Codec.INT.fieldOf("x_offset").forGetter(offset -> offset.getOffset().func_177958_n()), (App)Codec.INT.fieldOf("y_offset").forGetter(offset -> offset.getOffset().func_177956_o()), (App)Codec.INT.fieldOf("z_offset").forGetter(offset -> offset.getOffset().func_177952_p()), (App)Codec.BOOL.orElse((Object)false).optionalFieldOf("using_remote_image").forGetter(ConsoleRoom::isUsingRemoteImage), (App)Codec.STRING.orElse((Object)"").optionalFieldOf("remote_image_url").forGetter(ConsoleRoom::getImageUrl)).apply((Applicative)instance, ConsoleRoom::new));
    public static final ConsoleRoomCodecListener DATA_LOADER = new ConsoleRoomCodecListener("console_rooms", CODEC, Tardis.LOGGER);
    public static ConsoleRoom STEAM;
    public static ConsoleRoom JADE;
    public static ConsoleRoom NAUTILUS;
    public static ConsoleRoom OMEGA;
    public static ConsoleRoom ALABASTER;
    public static ConsoleRoom CORAL;
    public static ConsoleRoom METALLIC;
    public static ConsoleRoom ARCHITECT;
    public static ConsoleRoom TOYOTA;
    public static ConsoleRoom PANAMAX;
    public static ConsoleRoom TRAVELER;
    public static ConsoleRoom ENVOY;
    public static ConsoleRoom AMETHYST;
    public static ConsoleRoom IMPERIAL;
    public static ConsoleRoom ABANDONED_STEAM;
    public static ConsoleRoom ABANDONED_PANAMAX;
    public static ConsoleRoom ABANDONED_ALABASTER;
    public static ConsoleRoom ABANDONED_JADE;
    public static ConsoleRoom ABANDONED_NAUTILUS;
    public static ConsoleRoom ABANDONED_IMPERIAL;
    public static ConsoleRoom DEBUG_CLEAN;
    private ResourceLocation registryName;
    private ResourceLocation texture;
    private BlockPos offset;
    private ResourceLocation filePath;
    private boolean isDatapack = false;
    private boolean has_remote_url = false;
    private String remote_url = "";
    @Nullable
    private String translationKey;

    public ConsoleRoom(ResourceLocation filePath, BlockPos offset, ResourceLocation texture, String translationKey, boolean isDatapack, String imageUrl, boolean has_remote_url) {
        this.has_remote_url = has_remote_url;
        this.remote_url = imageUrl;
        this.offset = offset;
        this.filePath = filePath;
        this.texture = texture;
        this.translationKey = translationKey;
        this.isDatapack = isDatapack;
    }

    public ConsoleRoom(ResourceLocation filePath, String translationKey, ResourceLocation texture, int x, int y, int z, Optional<Boolean> has_remote_url, Optional<String> imageUrl) {
        this.has_remote_url = has_remote_url.get();
        this.remote_url = imageUrl.get();
        this.offset = new BlockPos(x, y, z);
        this.filePath = filePath;
        this.texture = texture;
        this.translationKey = translationKey;
        this.isDatapack = true;
    }

    public ConsoleRoom(BlockPos offset, String fileName, String texture) {
        this(new ResourceLocation("tardis", fileName), offset, new ResourceLocation("tardis", "textures/gui/interiors/" + texture + ".png"), "interiors.tardis." + fileName, false, "", false);
    }

    public static ConsoleRoom register(ConsoleRoom room, ResourceLocation registryName) {
        DATA_LOADER.getData().put(registryName, room.setRegistryName(registryName));
        if (registryName == null) {
            throw new NullPointerException();
        }
        return room;
    }

    private static ConsoleRoom register(ConsoleRoom room, String registryName) {
        return ConsoleRoom.register(room, Helper.createRL(registryName));
    }

    public static Map<ResourceLocation, ConsoleRoom> registerCoreConsoleRooms() {
        DATA_LOADER.getData().clear();
        Tardis.LOGGER.log(Level.INFO, "Cleared ConsoleRoom Registry!");
        STEAM = ConsoleRoom.register(new ConsoleRoom(new BlockPos(13, 11, 30), "interior_steam", "steam"), "steam");
        JADE = ConsoleRoom.register(new ConsoleRoom(new BlockPos(17, 8, 30), "interior_jade", "jade"), "jade");
        NAUTILUS = ConsoleRoom.register(new ConsoleRoom(new BlockPos(17, 17, 30), "interior_nautilus", "nautilus"), "nautilus");
        OMEGA = ConsoleRoom.register(new ConsoleRoom(new BlockPos(14, 15, 30), "interior_omega", "omega"), "omega");
        ALABASTER = ConsoleRoom.register(new ConsoleRoom(new BlockPos(15, 8, 30), "interior_alabaster", "alabaster"), "alabaster");
        ARCHITECT = ConsoleRoom.register(new ConsoleRoom(new BlockPos(14, 12, 30), "interior_architect", "architect"), "architect");
        CORAL = ConsoleRoom.register(new ConsoleRoom(new BlockPos(11, 11, 30), "interior_coral", "coral"), "coral");
        PANAMAX = ConsoleRoom.register(new ConsoleRoom(new BlockPos(14, 11, 30), "interior_panamax", "panamax"), "panamax");
        TOYOTA = ConsoleRoom.register(new ConsoleRoom(new BlockPos(20, 7, 30), "interior_toyota", "toyota"), "toyota");
        TRAVELER = ConsoleRoom.register(new ConsoleRoom(new BlockPos(14, 8, 30), "interior_traveler", "traveler"), "traveler");
        ENVOY = ConsoleRoom.register(new ConsoleRoom(new BlockPos(19, 3, 30), "interior_envoy", "envoy"), "envoy");
        AMETHYST = ConsoleRoom.register(new ConsoleRoom(new BlockPos(17, 8, 30), "interior_amethyst", "amethyst"), "amethyst");
        IMPERIAL = ConsoleRoom.register(new ConsoleRoom(new BlockPos(13, 6, 30), "interior_imperial", "imperial"), "imperial");
        DEBUG_CLEAN = ConsoleRoom.register(new ConsoleRoom(new BlockPos(2, 1, 4), "interior_debug_clean", "debug"), "debug");
        ABANDONED_STEAM = ConsoleRoom.register(new ConsoleRoom(new BlockPos(13, 11, 30), "interior_abandoned_steam", "abandoned_steam"), "abandoned_steam");
        ABANDONED_PANAMAX = ConsoleRoom.register(new ConsoleRoom(new BlockPos(14, 11, 30), "interior_abandoned_panamax", "abandoned_panamax"), "abandoned_panamax");
        ABANDONED_NAUTILUS = ConsoleRoom.register(new ConsoleRoom(new BlockPos(17, 17, 30), "interior_abandoned_nautilus", "abandoned_nautilus"), "abandoned_nautilus");
        ABANDONED_ALABASTER = ConsoleRoom.register(new ConsoleRoom(new BlockPos(15, 8, 30), "interior_abandoned_alabaster", "abandoned_alabaster"), "abandoned_alabaster");
        ABANDONED_IMPERIAL = ConsoleRoom.register(new ConsoleRoom(new BlockPos(13, 6, 30), "interior_abandoned_imperial", "abandoned_imperial"), "abandoned_imperial");
        ABANDONED_JADE = ConsoleRoom.register(new ConsoleRoom(new BlockPos(17, 8, 30), "interior_abandoned_jade", "abandoned_jade"), "abandoned_jade");
        DATA_LOADER.getData().values().forEach(interior -> Tardis.LOGGER.log(Level.INFO, "Registered core Console Room: " + interior.getRegistryName()));
        return DATA_LOADER.getData();
    }

    public static Codec<ConsoleRoom> getCodec() {
        return CODEC;
    }

    public static Map<ResourceLocation, ConsoleRoom> getRegistry() {
        return DATA_LOADER.getData();
    }

    public JsonElement toJson() {
        return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().get();
    }

    public static void readFromJson(JsonElement json, Consumer<String> logMessageOnBadData, Consumer<ConsoleRoom> onGoodData) {
        CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(logMessageOnBadData).ifPresent(onGoodData);
    }

    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this).resultOrPartial(arg_0 -> ((Logger)Tardis.LOGGER).error(arg_0)).ifPresent(data -> tag.func_218657_a("console_room", data));
        return tag;
    }

    public static ConsoleRoom deserialize(CompoundNBT tag) {
        ConsoleRoom interior = (ConsoleRoom)CODEC.parse(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a)).resultOrPartial(arg_0 -> ((Logger)Tardis.LOGGER).error(arg_0)).get();
        return interior;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public ConsoleRoom setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    public ResourceLocation getStructureFilePath() {
        return this.filePath;
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"interiors", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    public TranslationTextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public boolean isDataPack() {
        return this.isDatapack;
    }

    public Optional<String> getImageUrl() {
        return Optional.ofNullable(this.remote_url);
    }

    public Optional<Boolean> isUsingRemoteImage() {
        return Optional.ofNullable(this.has_remote_url);
    }

    public void spawnConsoleRoom(ServerWorld world, boolean overrideStructure) {
        ConsoleTile console = null;
        CompoundNBT consoleData = null;
        BlockState consoleState = null;
        int radius = 30;
        BlockPos clearRadius = new BlockPos(radius, radius, radius);
        if (world.func_175625_s(TardisHelper.TARDIS_POS) instanceof ConsoleTile) {
            console = (ConsoleTile)world.func_175625_s(TardisHelper.TARDIS_POS);
            consoleData = console.serializeNBT();
            consoleState = world.func_180495_p(TardisHelper.TARDIS_POS);
        }
        boolean hasCorridors = overrideStructure || world.func_180495_p(new BlockPos(0, 129, -30)).func_177230_c() != TBlocks.corridor_spawn.get();
        List<ItemStack> allInvs = ARSHelper.fillReclamationUnitAndRemove((World)world, TardisHelper.TARDIS_POS.func_177973_b((Vector3i)clearRadius), TardisHelper.TARDIS_POS.func_177971_a((Vector3i)clearRadius));
        AxisAlignedBB killBox = new AxisAlignedBB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius).func_186670_a(TardisHelper.TARDIS_POS);
        BlockPos tpPos = TardisHelper.TARDIS_POS.func_177972_a(Direction.NORTH);
        for (Entity entity : world.func_217357_a(Entity.class, killBox)) {
            if (entity.func_184216_O().contains("tardis_interior_change_kill")) {
                entity.func_70106_y();
            }
            if (!(entity instanceof LivingEntity)) {
                entity.func_70106_y();
            }
            if (entity instanceof PlayerEntity) {
                entity.func_70634_a((double)tpPos.func_177958_n() + 0.5, (double)tpPos.func_177956_o() + 0.5, (double)tpPos.func_177952_p() + 0.5);
            }
            if (entity instanceof ArmorStandEntity) {
                for (ItemStack armor : entity.func_184193_aE()) {
                    allInvs.add(armor.func_77946_l());
                }
                entity.func_70106_y();
            }
            if (entity instanceof ItemFrameEntity) {
                allInvs.add(((ItemFrameEntity)entity).func_82335_i());
                entity.func_70106_y();
            }
            if (!(entity instanceof LeashKnotEntity)) continue;
            allInvs.add(new ItemStack((IItemProvider)Items.field_151058_ca));
            entity.func_70106_y();
        }
        Template temp = world.func_184163_y().func_200219_b(this.filePath);
        if (temp != null) {
            temp.func_237144_a_((IServerWorld)world, TardisHelper.TARDIS_POS.func_177973_b((Vector3i)this.offset), new PlacementSettings().func_186222_a(false), world.field_73012_v);
        } else {
            Tardis.LOGGER.error("Error pasting template! Could not find template for file path {} in ConsoleRoom entry {}", (Object)this.filePath, (Object)this.registryName.toString());
        }
        if (hasCorridors && !overrideStructure) {
            BlockPos corridor = new BlockPos(0, 129, -30);
            for (int x = -1; x < 2; ++x) {
                for (int y = -1; y < 3; ++y) {
                    world.func_175656_a(corridor.func_177982_a(x, y, 0), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        if (console != null) {
            world.func_175656_a(TardisHelper.TARDIS_POS, consoleState);
            world.func_175625_s(TardisHelper.TARDIS_POS).deserializeNBT(consoleData);
        }
        if (!allInvs.isEmpty()) {
            world.func_175656_a(TardisHelper.TARDIS_POS.func_177970_e(2), ((Block)TBlocks.reclamation_unit.get()).func_176223_P());
            TileEntity te = world.func_175625_s(TardisHelper.TARDIS_POS.func_177970_e(2));
            if (te instanceof ReclamationTile) {
                ReclamationTile unit = (ReclamationTile)te;
                for (ItemStack stack : allInvs) {
                    unit.addItemStack(stack);
                }
            }
        }
        ChunkPos startPos = world.func_217349_x(TardisHelper.TARDIS_POS.func_177973_b((Vector3i)temp.func_186259_a())).func_76632_l();
        ChunkPos endPos = world.func_217349_x(TardisHelper.TARDIS_POS.func_177971_a((Vector3i)temp.func_186259_a())).func_76632_l();
        for (int x = startPos.field_77276_a; x < endPos.field_77276_a; ++x) {
            for (int z = startPos.field_77275_b; z < endPos.field_77275_b; ++z) {
                world.func_72863_F().func_212863_j_().func_215593_a((IChunk)world.func_212866_a_(x, z), true);
            }
        }
    }
}

