/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.ars;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.TranslationTextComponent;
import net.tardis.mod.ars.ARSPiece;

public class ARSPieceCategory {
    private String category;
    private List<ARSPieceCategory> children = Lists.newArrayList();
    private List<ARSPiece> pieces = Lists.newArrayList();
    private String translationKey;
    private String modid;

    public ARSPieceCategory(String categoryName, String modid) {
        this.category = categoryName;
        this.modid = modid;
    }

    public ARSPieceCategory add(String string, String modid) {
        if (this.get(string, modid) == null) {
            ARSPieceCategory newCat = new ARSPieceCategory(string, modid);
            this.children.add(newCat);
            return newCat;
        }
        return this.get(string, modid);
    }

    public ARSPieceCategory get(String name, String modid) {
        for (ARSPieceCategory cat : this.children) {
            if (!cat.categoryMatches(name, modid)) continue;
            return cat;
        }
        return null;
    }

    public boolean categoryMatches(String categoryName, String modid) {
        return this.category.contentEquals(categoryName) && this.modid.contentEquals(modid);
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"ars.piece.category", (ResourceLocation)new ResourceLocation(this.modid, this.category));
        }
        return this.translationKey;
    }

    public TranslationTextComponent getTranslation() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public boolean addPieceToList(@Nullable ARSPiece piece) {
        if (piece == null) {
            return false;
        }
        return this.pieces.add(piece);
    }

    public List<ARSPiece> getPieces() {
        return this.pieces;
    }

    public List<ARSPieceCategory> getChildren() {
        return this.children;
    }
}

