/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.ars;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.Tardis;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.ARSPieceCodecListener;
import net.tardis.mod.tileentities.CorridorKillTile;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ARSPiece {
    private static final Codec<ARSPiece> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("structure_resource_location").forGetter(ARSPiece::getStructureFilePath), (App)Codec.STRING.fieldOf("display_name").forGetter(name -> name.getDisplayName().getString()), (App)Codec.INT.fieldOf("x_offset").forGetter(offset -> offset.getOffset().func_177958_n()), (App)Codec.INT.fieldOf("y_offset").forGetter(offset -> offset.getOffset().func_177956_o()), (App)Codec.INT.fieldOf("z_offset").forGetter(offset -> offset.getOffset().func_177952_p())).apply((Applicative)instance, ARSPiece::new));
    public static final ARSPieceCodecListener DATA_LOADER = new ARSPieceCodecListener("ars_pieces", CODEC, Tardis.LOGGER);
    public static ARSPiece ALABASTER_SHORT;
    public static ARSPiece ALABASTER_LONG;
    public static ARSPiece ALABASTER_FOURWAY;
    public static ARSPiece ALABASTER_T_JUNCTION;
    public static ARSPiece ALABASTER_TURN_RIGHT;
    public static ARSPiece ALABASTER_TURN_LEFT;
    public static ARSPiece DARK_SHORT;
    public static ARSPiece DARK_LONG;
    public static ARSPiece DARK_FOURWAY;
    public static ARSPiece DARK_T_JUNCTION;
    public static ARSPiece DARK_TURN_RIGHT;
    public static ARSPiece DARK_TURN_LEFT;
    public static ARSPiece LARGE_ROOM;
    public static ARSPiece LIBRARY;
    public static ARSPiece SMALL_LAB;
    public static ARSPiece LAB;
    public static ARSPiece WORKROOM_1;
    public static ARSPiece WORKROOM_2;
    public static ARSPiece WORKROOM_3;
    public static ARSPiece STOREROOM;
    public static ARSPiece HYDROPONICS;
    public static ARSPiece HYDROPONICS_LARGE;
    public static ARSPiece ARS_TREE;
    public static ARSPiece GRAVITY_SHAFT_DOWN;
    public static ARSPiece GRAVITY_SHAFT_UP;
    public static ARSPiece ARCHIVES;
    public static ARSPiece CLOISTER;
    public static ARSPiece MACHINERY_WORKSHOP;
    public static ARSPiece STEAM_SHORT;
    public static ARSPiece STEAM_LONG;
    public static ARSPiece STEAM_FOURWAY;
    public static ARSPiece STEAM_T_JUNTION;
    public static ARSPiece STEAM_LEFT_TURN;
    public static ARSPiece STEAM_RIGHT_TURN;
    private ResourceLocation registryName;
    private ResourceLocation filePath;
    private BlockPos offset;
    private String translationKey;
    private boolean isDatapack = false;

    public ARSPiece(ResourceLocation filePath, String translationKey, BlockPos offset, boolean isDatapack) {
        this.filePath = filePath;
        this.offset = offset;
        this.translationKey = translationKey;
        this.isDatapack = isDatapack;
    }

    public ARSPiece(ResourceLocation filePath, String translationKey, int x, int y, int z, boolean isDatapack) {
        this.filePath = filePath;
        this.offset = new BlockPos(x, y, z);
        this.translationKey = translationKey;
        this.isDatapack = isDatapack;
    }

    public ARSPiece(ResourceLocation filePath, String translationKey, BlockPos offset) {
        this.filePath = filePath;
        this.offset = offset;
        this.translationKey = translationKey;
        this.isDatapack = true;
    }

    public ARSPiece(ResourceLocation filePath, String translationKey, int x, int y, int z) {
        this.filePath = filePath;
        this.offset = new BlockPos(x, y, z);
        this.translationKey = translationKey;
        this.isDatapack = true;
    }

    public ARSPiece(String fileName, String translationKey, int x, int y, int z) {
        this(new ResourceLocation("tardis", "ars/" + fileName), "ars.piece.tardis." + translationKey, new BlockPos(x, y, z), false);
    }

    public ARSPiece(String fileName, String translationKey, BlockPos offset) {
        this(new ResourceLocation("tardis", "ars/" + fileName), "ars.piece.tardis." + translationKey, offset, false);
    }

    public static ARSPiece register(ResourceLocation registryName, ARSPiece room) {
        DATA_LOADER.getData().put(registryName, room.setRegistryName(registryName));
        if (registryName == null) {
            throw new NullPointerException();
        }
        return room;
    }

    private static ARSPiece register(String registryName, ARSPiece room) {
        return ARSPiece.register(new ResourceLocation("tardis", registryName), room);
    }

    private static ARSPiece registerRoom(String registryName, String fileName, String translationKey, BlockPos offset) {
        return ARSPiece.register(new ResourceLocation("tardis", "room/" + registryName), new ARSPiece("room/" + fileName, "room." + translationKey, offset));
    }

    private static ARSPiece registerCorridor(String registryName, String fileName, String translationKey, BlockPos offset) {
        return ARSPiece.register(new ResourceLocation("tardis", "corridor/" + registryName), new ARSPiece("corridor/" + fileName, "corridor." + translationKey, offset));
    }

    public static Map<ResourceLocation, ARSPiece> registerCoreARSPieces() {
        DATA_LOADER.getData().clear();
        Tardis.LOGGER.log(Level.INFO, "Cleared ARS Registry!");
        ALABASTER_SHORT = ARSPiece.registerCorridor("alabaster/short", "alabaster/short", "alabaster.short", new BlockPos(4, 3, 11));
        ALABASTER_LONG = ARSPiece.registerCorridor("alabaster/long", "alabaster/long", "alabaster.long", new BlockPos(4, 3, 26));
        ALABASTER_FOURWAY = ARSPiece.registerCorridor("alabaster/fourway", "alabaster/fourway", "alabaster.fourway", new BlockPos(8, 3, 15));
        ALABASTER_T_JUNCTION = ARSPiece.registerCorridor("alabaster/t_junction", "alabaster/t_junction", "alabaster.t_junction", new BlockPos(8, 3, 11));
        ALABASTER_TURN_RIGHT = ARSPiece.registerCorridor("alabaster/turn_right", "alabaster/turn_right", "alabaster.turn_right", new BlockPos(4, 3, 11));
        ALABASTER_TURN_LEFT = ARSPiece.registerCorridor("alabaster/turn_left", "alabaster/turn_left", "alabaster.turn_left", new BlockPos(8, 3, 11));
        DARK_SHORT = ARSPiece.registerCorridor("dark/short", "dark/short", "dark.short", new BlockPos(4, 3, 11));
        DARK_LONG = ARSPiece.registerCorridor("dark/long", "dark/long", "dark.long", new BlockPos(4, 3, 26));
        DARK_FOURWAY = ARSPiece.registerCorridor("dark/fourway", "dark/fourway", "dark.fourway", new BlockPos(8, 3, 15));
        DARK_T_JUNCTION = ARSPiece.registerCorridor("dark/t_junction", "dark/t_junction", "dark.t_junction", new BlockPos(8, 3, 11));
        DARK_TURN_RIGHT = ARSPiece.registerCorridor("dark/turn_right", "dark/turn_right", "dark.turn_right", new BlockPos(4, 3, 11));
        DARK_TURN_LEFT = ARSPiece.registerCorridor("dark/turn_left", "dark/turn_left", "dark.turn_left", new BlockPos(8, 3, 11));
        LARGE_ROOM = ARSPiece.registerRoom("large_room", "large_room", "large_room", new BlockPos(10, 2, 27));
        LIBRARY = ARSPiece.registerRoom("library", "library", "library", new BlockPos(14, 2, 30));
        LAB = ARSPiece.registerRoom("lab", "lab", "lab", new BlockPos(10, 3, 24));
        WORKROOM_1 = ARSPiece.registerRoom("workroom_1", "workroom_1", "workroom_1", new BlockPos(6, 3, 13));
        WORKROOM_2 = ARSPiece.registerRoom("workroom_2", "workroom_2", "workroom_2", new BlockPos(7, 3, 15));
        WORKROOM_3 = ARSPiece.registerRoom("workroom_3", "workroom_3", "workroom_3", new BlockPos(7, 3, 15));
        STOREROOM = ARSPiece.registerRoom("storeroom", "storeroom", "storeroom", new BlockPos(3, 3, 7));
        HYDROPONICS = ARSPiece.registerRoom("hydroponics", "hydroponics", "hydroponics", new BlockPos(8, 4, 23));
        HYDROPONICS_LARGE = ARSPiece.registerRoom("hydroponics_large", "hydroponics_large", "hydroponics_large", new BlockPos(13, 5, 27));
        ARS_TREE = ARSPiece.registerRoom("ars_tree", "ars_tree", "ars_tree", new BlockPos(8, 3, 18));
        GRAVITY_SHAFT_DOWN = ARSPiece.registerRoom("gravity_shaft_down", "gravity_shaft_down", "gravity_shaft_down", new BlockPos(5, 15, 11));
        GRAVITY_SHAFT_UP = ARSPiece.registerRoom("gravity_shaft_up", "gravity_shaft_up", "gravity_shaft_up", new BlockPos(5, 4, 11));
        ARCHIVES = ARSPiece.registerRoom("archives", "archives", "archives", new BlockPos(11, 3, 25));
        CLOISTER = ARSPiece.registerRoom("cloister", "cloister", "cloister", new BlockPos(15, 4, 30));
        MACHINERY_WORKSHOP = ARSPiece.registerRoom("machinery_workshop", "machinery_workshop", "machinery_workshop", new BlockPos(7, 11, 19));
        STEAM_FOURWAY = ARSPiece.registerCorridorEasy("steam/fourway", new BlockPos(8, 3, 15));
        STEAM_LEFT_TURN = ARSPiece.registerCorridorEasy("steam/turn_left", new BlockPos(8, 3, 11));
        STEAM_RIGHT_TURN = ARSPiece.registerCorridorEasy("steam/turn_right", new BlockPos(4, 3, 11));
        STEAM_LONG = ARSPiece.registerCorridorEasy("steam/long", new BlockPos(4, 3, 26));
        STEAM_SHORT = ARSPiece.registerCorridorEasy("steam/short", new BlockPos(4, 3, 11));
        STEAM_T_JUNTION = ARSPiece.registerCorridorEasy("steam/t_junction", new BlockPos(8, 3, 11));
        DATA_LOADER.getData().values().forEach(piece -> Tardis.LOGGER.log(Level.INFO, "Registered core ARSPiece: " + piece.getRegistryName()));
        return DATA_LOADER.getData();
    }

    public static ARSPiece registerCorridorEasy(String name, BlockPos pos) {
        String translation = name.replaceAll("/", ".");
        return ARSPiece.registerCorridor(name, name, translation, pos);
    }

    public boolean spawn(ServerWorld world, BlockPos pos, PlayerEntity player, Direction dir) {
        Template temp = world.func_184163_y().func_200219_b(this.filePath);
        BlockPos offset = WorldHelper.rotateBlockPos(this.offset, dir);
        if (temp != null) {
            BlockPos spawnStart = pos.func_177973_b((Vector3i)offset);
            BlockPos endPos = spawnStart.func_177971_a((Vector3i)WorldHelper.rotateBlockPos(temp.func_186259_a().func_177978_c().func_177976_e(), dir));
            for (BlockPos check : BlockPos.func_218278_a((BlockPos)spawnStart, (BlockPos)endPos)) {
                if (world.func_180495_p(check).isAir((IBlockReader)world, check)) continue;
                player.func_146105_b((ITextComponent)TardisConstants.Translations.CORRIDOR_BLOCKED, false);
                TextComponent startPosPrint = TextHelper.getBlockPosObject(spawnStart);
                TextComponent endPosPrint = TextHelper.getBlockPosObject(endPos);
                TextComponent conflictPos = TextHelper.getBlockPosObject(check);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.corridor.blocked_positions", new Object[]{startPosPrint, endPosPrint, conflictPos}), false);
                System.out.println("Structure tried to start spawning at: " + spawnStart + " and End Pos of: " + endPos + "With Offset of: " + offset + " from Start Pos");
                System.out.println("Conflict in structure creation detected at: " + check);
                return false;
            }
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y < 3; ++y) {
                    if (dir == Direction.SOUTH || dir == Direction.NORTH) {
                        world.func_175656_a(pos.func_177982_a(x, y, 0), Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    world.func_175656_a(pos.func_177982_a(0, y, x), Blocks.field_150350_a.func_176223_P());
                }
            }
            PlacementSettings set = new PlacementSettings().func_186222_a(false).func_186220_a(WorldHelper.getRotationFromDirection(dir));
            temp.func_237144_a_((IServerWorld)world, spawnStart, set, world.field_73012_v);
            for (Template.BlockInfo info : temp.func_215381_a(spawnStart, set, (Block)TBlocks.corridor_kill.get())) {
                TileEntity te = world.func_175625_s(info.field_186242_a);
                if (!(te instanceof CorridorKillTile)) continue;
                CorridorKillTile tile = (CorridorKillTile)te;
                tile.setStart(spawnStart);
                tile.setEnd(endPos);
                tile.setRestorePos(pos, dir);
            }
            return true;
        }
        Tardis.LOGGER.error("Error pasting template! Could not find template for file path {} in ARSPiece entry {}", (Object)this.filePath, (Object)this.registryName.toString());
        PlayerHelper.sendMessageToPlayer(player, new TranslationTextComponent("message.tardis.ars.structure_not_found", new Object[]{this.filePath}), false);
        return false;
    }

    public static Codec<ARSPiece> getCodec() {
        return CODEC;
    }

    public static Map<ResourceLocation, ARSPiece> getRegistry() {
        return DATA_LOADER.getData();
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public ARSPiece setRegistryName(ResourceLocation regName) {
        this.registryName = regName;
        return this;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"ars.piece", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    public TranslationTextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public ResourceLocation getStructureFilePath() {
        return this.filePath;
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public boolean isDataPack() {
        return this.isDatapack;
    }

    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this).resultOrPartial(arg_0 -> ((Logger)Tardis.LOGGER).error(arg_0)).ifPresent(data -> tag.func_218657_a("ars_piece", data));
        return tag;
    }

    public static ARSPiece deserialize(CompoundNBT tag) {
        ARSPiece interior = (ARSPiece)CODEC.parse(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a)).resultOrPartial(arg_0 -> ((Logger)Tardis.LOGGER).error(arg_0)).get();
        return interior;
    }
}

