/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.ars;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.items.DataCrystalItem;
import net.tardis.mod.items.TItems;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.tags.TardisBlockTags;
import net.tardis.mod.tileentities.ReclamationTile;
import net.tardis.mod.tileentities.WaypointBankTile;

public class ARSHelper {
    public static List<ItemStack> fillReclamationUnitAndRemove(World world, BlockPos start, BlockPos end) {
        return ARSHelper.fillReclamationUnitAndRemove(world, start, end, false);
    }

    public static List<ItemStack> fillReclamationUnitAndRemove(World world, BlockPos start, BlockPos end, boolean removeEntities) {
        ArrayList allInvs = Lists.newArrayList();
        BlockPos.func_218281_b((BlockPos)start, (BlockPos)end).forEach(pos -> {
            TileEntity tile = world.func_175625_s(pos);
            if (tile == null) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 34);
                return;
            }
            if (tile.func_195044_w().func_235714_a_(TardisBlockTags.RECLAMATION_BLACKLIST)) {
                return;
            }
            if (tile instanceof IInventory) {
                IInventory inv = (IInventory)tile;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    allInvs.add(stack.func_77946_l());
                }
            } else if (tile != null) {
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(cap -> {
                    for (int i = 0; i < cap.getSlots(); ++i) {
                        ItemStack stack = cap.getStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        allInvs.add(stack.func_77946_l());
                    }
                });
            }
            if (tile instanceof WaypointBankTile) {
                ArrayList stored = Lists.newArrayList(((WaypointBankTile)tile).getWaypoints());
                stored.removeIf(coord -> coord.equals(SpaceTimeCoord.UNIVERAL_CENTER));
                if (!stored.isEmpty()) {
                    ItemStack stack = new ItemStack((IItemProvider)TItems.DATA_CRYSTAL.get());
                    DataCrystalItem.setStoredWaypoints(stack, stored);
                    allInvs.add(stack);
                }
            }
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 34);
        });
        if (removeEntities) {
            AxisAlignedBB killBox = new AxisAlignedBB(start, end);
            for (Entity entity : world.func_217357_a(Entity.class, killBox)) {
                if (entity.func_184216_O().contains("tardis_interior_change_kill")) {
                    entity.func_70106_y();
                }
                if (!(entity instanceof LivingEntity)) {
                    entity.func_70106_y();
                }
                if (entity instanceof ArmorStandEntity) {
                    for (ItemStack armor : entity.func_184193_aE()) {
                        allInvs.add(armor.func_77946_l());
                    }
                    entity.func_70106_y();
                }
                if (entity instanceof ItemFrameEntity) {
                    allInvs.add(((ItemFrameEntity)entity).func_82335_i());
                    entity.func_70106_y();
                }
                if (!(entity instanceof LeashKnotEntity)) continue;
                allInvs.add(new ItemStack((IItemProvider)Items.field_151058_ca));
                entity.func_70106_y();
            }
        }
        return allInvs;
    }

    public static void spawnReclamationUnit(World world, BlockPos spawnPos, List<ItemStack> stacksToStore) {
        if (!stacksToStore.isEmpty()) {
            TileEntity te;
            if (world.func_180495_p(spawnPos).func_177230_c() != TBlocks.reclamation_unit.get()) {
                world.func_175656_a(spawnPos, ((Block)TBlocks.reclamation_unit.get()).func_176223_P());
            }
            if ((te = world.func_175625_s(spawnPos)) instanceof ReclamationTile) {
                ReclamationTile unit = (ReclamationTile)te;
                for (ItemStack stack : stacksToStore) {
                    unit.addItemStack(stack);
                }
            }
        }
    }
}

